/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.utils;

import com.libraries.rabbit.gui.RabbitGui;
import com.libraries.rabbit.gui.utils.ImageCacheHelper;
import com.libraries.rabbit.gui.utils.TextureHelper;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class SkinManager {
    private static Map<String, UUID> playerSkin = new HashMap<String, UUID>();
    private static Map<String, Integer> textureSize = new HashMap<String, Integer>();

    public static void addSkin(EntityPlayer player, String skin) {
        SkinManager.addSkin(player.func_70005_c_(), skin);
    }

    public static void addSkin(String player, ResourceLocation skin) {
        if (skin != null) {
            UUID textureId = UUID.randomUUID();
            TextureHelper.addStaticTexture(textureId, skin);
            playerSkin.put(player, textureId);
        }
    }

    public static void addSkin(String player, String skin) {
        if (skin != null && !skin.isEmpty()) {
            UUID textureId = UUID.randomUUID();
            TextureHelper.addTexture(textureId, skin);
            playerSkin.put(player, textureId);
        }
    }

    public static boolean bindSkinTexture(EntityPlayer player) {
        return SkinManager.bindSkinTexture(player.func_70005_c_());
    }

    public static boolean bindSkinTexture(String player) {
        if (playerSkin.containsKey(player)) {
            TextureHelper.bindTexture(playerSkin.get(player));
            return true;
        }
        return false;
    }

    public static String getSkinTexture(EntityPlayer player) {
        return SkinManager.getSkinTexture(player.func_70005_c_());
    }

    public static String getSkinTexture(String player) {
        ResourceLocation tex;
        if (playerSkin.containsKey(player) && TextureHelper.getDynamicTexture(playerSkin.get(player)) == null && (tex = TextureHelper.getStaticTexture(playerSkin.get(player))) != null) {
            return tex.toString();
        }
        return null;
    }

    public static int getSkinTextureHeight(EntityPlayer player) {
        return SkinManager.getSkinTextureHeight(player.func_70005_c_());
    }

    public static int getSkinTextureHeight(String player) {
        if (textureSize.containsKey(player)) {
            return textureSize.get(player);
        }
        return 64;
    }

    public static boolean hasSkinTexture(EntityPlayer player) {
        return SkinManager.hasSkinTexture(player.func_70005_c_());
    }

    public static boolean hasSkinTexture(String player) {
        return playerSkin.containsKey(player);
    }

    public static void removeSkinTexture(EntityPlayer player) {
        SkinManager.removeSkinTexture(player.func_70005_c_());
    }

    public static void removeSkinTexture(String player) {
        playerSkin.remove(player);
        textureSize.remove(player);
    }

    public static void setSkinTexture(EntityPlayer player, ResourceLocation skin) {
        SkinManager.setSkinTexture(player.func_70005_c_(), skin);
    }

    public static void setSkinTexture(EntityPlayer player, String skin) {
        SkinManager.setSkinTexture(player.func_70005_c_(), skin);
    }

    public static void setSkinTexture(String player, ResourceLocation skin) {
        if (skin != null) {
            if (playerSkin.containsKey(player)) {
                UUID textureId = UUID.randomUUID();
                TextureHelper.addStaticTexture(textureId, skin);
                playerSkin.replace(player, textureId);
            } else {
                SkinManager.addSkin(player, skin);
            }
            SkinManager.setTextureDimension(player, skin);
        }
    }

    public static void setSkinTexture(String player, String skin) {
        if (skin != null && !skin.isEmpty()) {
            if (playerSkin.containsKey(player)) {
                UUID textureId = UUID.randomUUID();
                TextureHelper.addTexture(textureId, skin);
                playerSkin.replace(player, textureId);
            } else {
                SkinManager.addSkin(player, skin);
            }
            SkinManager.setTextureDimension(player, skin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTextureDimension(String player, ResourceLocation skin) {
        InputStream inputstream = null;
        try {
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(skin);
            inputstream = iresource.func_110527_b();
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)inputstream);
            if (textureSize.containsKey(player)) {
                textureSize.replace(player, bufferedimage.getHeight());
            } else {
                textureSize.put(player, bufferedimage.getHeight());
            }
        }
        catch (FileNotFoundException fnfe) {
            RabbitGui.logger.error("Could not determine texture size", (Throwable)fnfe);
        }
        catch (IOException e) {
            RabbitGui.logger.error("Could not determine texture size", (Throwable)e);
        }
        finally {
            if (inputstream != null) {
                try {
                    inputstream.close();
                }
                catch (IOException e) {
                    RabbitGui.logger.error("Failed during player render, could not close inputstream", (Throwable)e);
                }
            }
        }
    }

    private static void setTextureDimension(String player, String skin) {
        try {
            BufferedImage bufferedimage = ImageCacheHelper.fetchImage(new URL(skin));
            if (bufferedimage != null) {
                if (textureSize.containsKey(player)) {
                    textureSize.replace(player, bufferedimage.getHeight());
                } else {
                    textureSize.put(player, bufferedimage.getHeight());
                }
            }
        }
        catch (MalformedURLException e) {
            RabbitGui.logger.error(e.getLocalizedMessage() + "\nCould not determine texture size from url, attempting resource location method");
            SkinManager.setTextureDimension(player, new ResourceLocation(skin));
        }
    }
}

