/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.api;

import com.robertx22.spells.bases.MyDamageSource;
import com.robertx22.uncommon.capability.EntityData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MineAndSlashEvents {

    public static class DamageEvent
    extends Event {
        private final EntityLivingBase source;
        private final EntityLivingBase target;
        private final float totalDamage;
        private final MyDamageSource damageSource;
        private final boolean fullyBlocked;

        public DamageEvent(EntityLivingBase source, EntityLivingBase target, float totalDamage, MyDamageSource damageEffect, boolean fullyBlocked) {
            this.source = source;
            this.target = target;
            this.totalDamage = totalDamage;
            this.damageSource = damageEffect;
            this.fullyBlocked = fullyBlocked;
        }

        public EntityLivingBase getSource() {
            return this.source;
        }

        public EntityLivingBase getTarget() {
            return this.target;
        }

        public float getTotalDamage() {
            return this.totalDamage;
        }

        public float getAdjustedDamage() {
            return this.damageSource.realDamage;
        }

        public float getBlockedDamage() {
            return this.fullyBlocked ? this.totalDamage : this.totalDamage - (float)this.damageSource.realDamage;
        }

        public MyDamageSource getDamageSource() {
            return this.damageSource;
        }

        public boolean isFullyBlocked() {
            return this.fullyBlocked;
        }
    }

    public static class GiveExpEvent
    extends LivingEvent {
        public int experience = 0;
        public EntityData.UnitData playerCapability;

        public GiveExpEvent(EntityPlayer entity, EntityData.UnitData playerdata, int exp) {
            super((EntityLivingBase)entity);
            this.playerCapability = playerdata;
            this.experience = exp;
            this.setResult(Event.Result.ALLOW);
        }
    }
}

