/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.blocks.item_modify_station;

import com.robertx22.blocks.BaseTile;
import com.robertx22.items.currency.ICurrencyItemEffect;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.datasaving.Gear;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TileInventoryModify
extends BaseTile {
    public static final int INPUT_SLOTS_COUNT = 2;
    public static final int OUTPUT_SLOTS_COUNT = 1;
    public static final int TOTAL_SLOTS_COUNT = 3;
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int FIRST_OUTPUT_SLOT = 2;
    private short cookTime;
    private static final short COOK_TIME_FOR_COMPLETION = 200;
    int ticks = 0;
    private static final byte COOK_FIELD_ID = 0;
    private static final byte NUMBER_OF_FIELDS = 1;

    @Override
    public boolean isAutomatable() {
        return false;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        return true;
    }

    public ItemStack getSmeltingResultForItem(ItemStack stack) {
        ItemStack gearStack = this.GearSlot();
        ItemStack craftStack = this.CraftItemSlot();
        if (gearStack == null || gearStack.func_190926_b() || craftStack == null || craftStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        GearItemData gear = Gear.Load(stack);
        if (gear != null && craftStack.func_77973_b() instanceof ICurrencyItemEffect) {
            ICurrencyItemEffect effect = (ICurrencyItemEffect)craftStack.func_77973_b();
            if (effect.canItemBeModified(gearStack, craftStack)) {
                ItemStack copy = gearStack.func_77946_l();
                copy = effect.ModifyItem(copy, craftStack);
                return copy;
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack GearSlot() {
        return this.itemStacks[0];
    }

    public ItemStack CraftItemSlot() {
        return this.itemStacks[1];
    }

    public TileInventoryModify() {
        this.itemStacks = new ItemStack[3];
        this.func_174888_l();
    }

    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / 200.0;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticks;
            if (this.ticks > 20) {
                this.ticks = 0;
                if (this.canSmelt()) {
                    this.cookTime = (short)(this.cookTime + 20);
                    if (this.cookTime < 0) {
                        this.cookTime = 0;
                    }
                    if (this.cookTime >= 200) {
                        this.smeltItem();
                        this.cookTime = 0;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
        }
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        Integer firstSuitableInputSlot = null;
        Integer firstSuitableOutputSlot = null;
        ItemStack result = ItemStack.field_190927_a;
        for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
            if (this.itemStacks[inputSlot].func_190926_b() || (result = this.getSmeltingResultForItem(this.itemStacks[inputSlot])).func_190926_b()) continue;
            for (int outputSlot = 2; outputSlot < 3; ++outputSlot) {
                int combinedSize;
                ItemStack outputStack = this.itemStacks[outputSlot];
                if (outputStack.func_190926_b()) {
                    firstSuitableInputSlot = inputSlot;
                    firstSuitableOutputSlot = outputSlot;
                    break;
                }
                if (outputStack.func_77973_b() != result.func_77973_b() || outputStack.func_77981_g() && outputStack.func_77960_j() != outputStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)result) || (combinedSize = this.itemStacks[outputSlot].func_190916_E() + result.func_190916_E()) > this.func_70297_j_() || combinedSize > this.itemStacks[outputSlot].func_77976_d()) continue;
                firstSuitableInputSlot = inputSlot;
                firstSuitableOutputSlot = outputSlot;
                break;
            }
            if (firstSuitableInputSlot != null) break;
        }
        if (firstSuitableInputSlot == null) {
            return false;
        }
        if (!performSmelt) {
            return true;
        }
        this.itemStacks[firstSuitableInputSlot].func_190918_g(1);
        if (this.itemStacks[firstSuitableInputSlot].func_190916_E() <= 0) {
            this.itemStacks[firstSuitableInputSlot.intValue()] = ItemStack.field_190927_a;
        }
        if (this.itemStacks[firstSuitableOutputSlot].func_190926_b()) {
            this.itemStacks[firstSuitableOutputSlot.intValue()] = result.func_77946_l();
            result = ItemStack.field_190927_a;
        } else {
            int newStackSize = this.itemStacks[firstSuitableOutputSlot].func_190916_E() + result.func_190916_E();
            this.itemStacks[firstSuitableOutputSlot].func_190920_e(newStackSize);
        }
        this.CraftItemSlot().func_190920_e(this.CraftItemSlot().func_190916_E() - 1);
        this.func_70296_d();
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        NBTTagList dataForAllSlots = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i].func_190926_b()) continue;
            NBTTagCompound dataForThisSlot = new NBTTagCompound();
            dataForThisSlot.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(dataForThisSlot);
            dataForAllSlots.func_74742_a((NBTBase)dataForThisSlot);
        }
        parentNBTTagCompound.func_74782_a("Items", (NBTBase)dataForAllSlots);
        parentNBTTagCompound.func_74777_a("CookTime", this.cookTime);
        return parentNBTTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        int NBT_TYPE_COMPOUND = 10;
        NBTTagList dataForAllSlots = nbtTagCompound.func_150295_c("Items", 10);
        Arrays.fill(this.itemStacks, ItemStack.field_190927_a);
        for (int i = 0; i < dataForAllSlots.func_74745_c(); ++i) {
            NBTTagCompound dataForOneSlot = dataForAllSlots.func_150305_b(i);
            byte slotNumber = dataForOneSlot.func_74771_c("Slot");
            if (slotNumber < 0 || slotNumber >= this.itemStacks.length) continue;
            this.itemStacks[slotNumber] = new ItemStack(dataForOneSlot);
        }
        this.cookTime = nbtTagCompound.func_74765_d("CookTime");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound updateTagDescribingTileEntityState = this.func_189517_E_();
        boolean METADATA = false;
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, updateTagDescribingTileEntityState);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound updateTagDescribingTileEntityState = pkt.func_148857_g();
        this.handleUpdateTag(updateTagDescribingTileEntityState);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public String func_70005_c_() {
        return CLOC.blank("tile.mmorpg:modify_station.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.cookTime;
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.cookTime = (short)value;
        }
    }

    public int func_174890_g() {
        return 1;
    }
}

