/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.blocks.repair_station;

import com.robertx22.blocks.BaseTile;
import com.robertx22.items.misc.ItemCapacitor;
import com.robertx22.items.ores.ItemOre;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.datasaving.Gear;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TileInventoryRepair
extends BaseTile {
    private int FuelRemaining = 0;
    private int MaximumFuel = 5000;
    public static final int FUEL_SLOTS_COUNT = 1;
    public static final int INPUT_SLOTS_COUNT = 5;
    public static final int OUTPUT_SLOTS_COUNT = 5;
    public static final int TOTAL_SLOTS_COUNT = 12;
    public static final int FIRST_FUEL_SLOT = 0;
    public static final int FIRST_INPUT_SLOT = 1;
    public static final int FIRST_OUTPUT_SLOT = 6;
    public static final int FIRST_CAPACITOR_SLOT = 11;
    private short cookTime;
    private static final short COOK_TIME_FOR_COMPLETION = 200;
    int ticks = 0;
    private static final byte COOK_FIELD_ID = 0;
    private static final byte FIRST_BURN_TIME_REMAINING_FIELD_ID = 1;
    private static final byte FIRST_BURN_TIME_INITIAL_FIELD_ID = 2;
    private static final byte NUMBER_OF_FIELDS = 3;

    @Override
    public boolean isAutomatable() {
        return false;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        return !this.getSmeltingResultForItem(stack).func_190926_b();
    }

    public ItemStack getSmeltingResultForItem(ItemStack stack) {
        GearItemData gear = Gear.Load(stack);
        if (gear != null) {
            ItemStack copy = stack.func_77946_l();
            int dmg = copy.func_77952_i() - this.FuelRemaining;
            if (dmg < 0) {
                dmg = 0;
            }
            copy.func_77964_b(dmg);
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    public TileInventoryRepair() {
        this.itemStacks = new ItemStack[12];
        this.func_174888_l();
    }

    public double fractionOfFuelRemaining(int fuelSlot) {
        if (this.FuelRemaining <= 0) {
            return 0.0;
        }
        double fraction = (double)this.FuelRemaining / (double)this.MaximumFuel;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    public int secondsOfFuelRemaining(int fuelSlot) {
        if (this.FuelRemaining <= 0) {
            return 0;
        }
        return this.FuelRemaining;
    }

    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / 200.0;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int numberOfFuelBurning = this.burnFuel();
            ++this.ticks;
            if (this.ticks > 20) {
                this.ticks = 0;
                if (this.canSmelt()) {
                    this.cookTime = (short)(this.cookTime + 20);
                    if (this.cookTime < 0) {
                        this.cookTime = 0;
                    }
                    if (this.cookTime >= 200) {
                        this.smeltItem();
                        this.cookTime = 0;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
        }
    }

    private int burnFuel() {
        int burningCount = 0;
        boolean inventoryChanged = false;
        for (int i = 0; i < 1; ++i) {
            int fuelSlotNumber = i + 0;
            if (this.FuelRemaining >= this.MaximumFuel || this.itemStacks[fuelSlotNumber].func_190926_b() || !(this.itemStacks[fuelSlotNumber].func_77973_b() instanceof ItemOre)) continue;
            ItemOre ore = (ItemOre)this.itemStacks[fuelSlotNumber].func_77973_b();
            this.FuelRemaining += ore.GetFuelValue();
            this.itemStacks[fuelSlotNumber].func_190918_g(1);
            ++burningCount;
            inventoryChanged = true;
            if (this.itemStacks[fuelSlotNumber].func_190916_E() != 0) continue;
            this.itemStacks[fuelSlotNumber] = this.itemStacks[fuelSlotNumber].func_77973_b().getContainerItem(this.itemStacks[fuelSlotNumber]);
        }
        if (inventoryChanged) {
            this.func_70296_d();
        }
        return burningCount;
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        Item item;
        if (this.FuelRemaining < 1) {
            return false;
        }
        Integer firstSuitableInputSlot = null;
        Integer firstSuitableOutputSlot = null;
        ItemStack result = ItemStack.field_190927_a;
        int fuelNeeded = 0;
        float fuelMulti = 1.0f;
        if (!this.itemStacks[11].func_190926_b() && (item = this.itemStacks[11].func_77973_b()) instanceof ItemCapacitor) {
            fuelMulti = ((ItemCapacitor)item).GetFuelMultiplier().floatValue();
        }
        for (int inputSlot = 1; inputSlot < 6; ++inputSlot) {
            if (this.itemStacks[inputSlot].func_190926_b()) continue;
            fuelNeeded = this.itemStacks[inputSlot].func_77952_i();
            if (fuelNeeded > this.FuelRemaining) {
                fuelNeeded = this.FuelRemaining;
            }
            if ((result = (float)fuelNeeded * fuelMulti <= (float)this.FuelRemaining ? this.getSmeltingResultForItem(this.itemStacks[inputSlot]) : ItemStack.field_190927_a).func_190926_b()) continue;
            for (int outputSlot = 6; outputSlot < 11; ++outputSlot) {
                int combinedSize;
                ItemStack outputStack = this.itemStacks[outputSlot];
                if (outputStack.func_190926_b()) {
                    firstSuitableInputSlot = inputSlot;
                    firstSuitableOutputSlot = outputSlot;
                    break;
                }
                if (outputStack.func_77973_b() != result.func_77973_b() || outputStack.func_77981_g() && outputStack.func_77960_j() != outputStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)result) || (combinedSize = this.itemStacks[outputSlot].func_190916_E() + result.func_190916_E()) > this.func_70297_j_() || combinedSize > this.itemStacks[outputSlot].func_77976_d()) continue;
                firstSuitableInputSlot = inputSlot;
                firstSuitableOutputSlot = outputSlot;
                break;
            }
            if (firstSuitableInputSlot != null) break;
        }
        if (firstSuitableInputSlot == null) {
            return false;
        }
        if (!performSmelt) {
            return true;
        }
        this.itemStacks[firstSuitableInputSlot].func_190918_g(1);
        if (this.itemStacks[firstSuitableInputSlot].func_190916_E() <= 0) {
            this.itemStacks[firstSuitableInputSlot.intValue()] = ItemStack.field_190927_a;
        }
        if (this.itemStacks[firstSuitableOutputSlot].func_190926_b()) {
            this.itemStacks[firstSuitableOutputSlot.intValue()] = result.func_77946_l();
        } else {
            int newStackSize = this.itemStacks[firstSuitableOutputSlot].func_190916_E() + result.func_190916_E();
            this.itemStacks[firstSuitableOutputSlot].func_190920_e(newStackSize);
        }
        this.FuelRemaining = (int)((float)this.FuelRemaining - (float)fuelNeeded * fuelMulti);
        this.func_70296_d();
        return true;
    }

    public static short getItemBurnTime(ItemStack stack) {
        int burntime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return (short)MathHelper.func_76125_a((int)burntime, (int)0, (int)Short.MAX_VALUE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        NBTTagList dataForAllSlots = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i].func_190926_b()) continue;
            NBTTagCompound dataForThisSlot = new NBTTagCompound();
            dataForThisSlot.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(dataForThisSlot);
            dataForAllSlots.func_74742_a((NBTBase)dataForThisSlot);
        }
        parentNBTTagCompound.func_74782_a("Items", (NBTBase)dataForAllSlots);
        parentNBTTagCompound.func_74777_a("CookTime", this.cookTime);
        parentNBTTagCompound.func_74768_a("fuel", this.FuelRemaining);
        return parentNBTTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        int NBT_TYPE_COMPOUND = 10;
        NBTTagList dataForAllSlots = nbtTagCompound.func_150295_c("Items", 10);
        Arrays.fill(this.itemStacks, ItemStack.field_190927_a);
        for (int i = 0; i < dataForAllSlots.func_74745_c(); ++i) {
            NBTTagCompound dataForOneSlot = dataForAllSlots.func_150305_b(i);
            byte slotNumber = dataForOneSlot.func_74771_c("Slot");
            if (slotNumber < 0 || slotNumber >= this.itemStacks.length) continue;
            this.itemStacks[slotNumber] = new ItemStack(dataForOneSlot);
        }
        this.cookTime = nbtTagCompound.func_74765_d("CookTime");
        this.FuelRemaining = nbtTagCompound.func_74762_e("fuel");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound updateTagDescribingTileEntityState = this.func_189517_E_();
        boolean METADATA = false;
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, updateTagDescribingTileEntityState);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound updateTagDescribingTileEntityState = pkt.func_148857_g();
        this.handleUpdateTag(updateTagDescribingTileEntityState);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public String func_70005_c_() {
        return CLOC.blank("tile.mmorpg:repair_station.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.cookTime;
        }
        if (id >= 1 && id < 2) {
            return this.FuelRemaining;
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.cookTime = (short)value;
        } else if (id >= 1 && id < 2) {
            this.FuelRemaining = value;
        }
    }

    public int func_174890_g() {
        return 3;
    }
}

