/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.config.non_mine_items;

import com.robertx22.config.ModConfig;
import com.robertx22.config.non_mine_items.WeightedType;
import com.robertx22.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.db_lists.GearTypes;
import com.robertx22.generation.GearGen;
import com.robertx22.generation.RunedGearGen;
import com.robertx22.generation.UniqueGearGen;
import com.robertx22.generation.blueprints.GearBlueprint;
import com.robertx22.generation.blueprints.RunedGearBlueprint;
import com.robertx22.generation.blueprints.UniqueBlueprint;
import com.robertx22.items.unique_items.IUnique;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.uncommon.datasaving.Gear;
import com.robertx22.uncommon.utilityclasses.IWeighted;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ConfigItem
implements IWeighted {
    public transient String registryName = "";
    public String itemType = "Sword";
    public boolean isSalvagable;
    public int dropWeight;
    public int uniqueItemWeight;
    public int normalItemWeight;
    public int runedItemWeight;
    public int randomUniqueUpToTier;
    public int minRarity;
    public int maxRarity;
    public int levelVariance;
    public String uniqueId;
    public boolean uniqueIsRandom;
    public int minLevel;
    public int maxLevel;
    public boolean statsAddedOnlyOnDrop;
    public boolean dropsAsLoot;

    public ConfigItem() {
        this.isSalvagable = ModConfig.Server.COMPATIBLE_ITEMS_SALVAGABLE;
        this.dropWeight = 1000;
        this.uniqueItemWeight = 0;
        this.normalItemWeight = 80;
        this.runedItemWeight = 20;
        this.randomUniqueUpToTier = 10;
        this.minRarity = 0;
        this.maxRarity = 5;
        this.levelVariance = 0;
        this.uniqueId = "";
        this.uniqueIsRandom = true;
        this.minLevel = 1;
        this.maxLevel = 100;
        this.statsAddedOnlyOnDrop = ModConfig.Server.STATS_ADDED_ONLY_ON_DROP;
        this.dropsAsLoot = true;
    }

    @Override
    public int Weight() {
        return this.dropWeight;
    }

    public ConfigItem setUniqueId(IUnique uniq) {
        this.uniqueId = uniq.GUID();
        this.uniqueIsRandom = false;
        return this;
    }

    public ConfigItem setMaxUniqueTier(int tier) {
        this.randomUniqueUpToTier = tier;
        return this;
    }

    public ConfigItem setstatsAddedOnlyOnDrop(boolean bool) {
        this.statsAddedOnlyOnDrop = bool;
        return this;
    }

    public ConfigItem setdropsAsLoot(boolean bool) {
        this.dropsAsLoot = bool;
        return this;
    }

    public ConfigItem setAlwaysNormal() {
        this.normalItemWeight = 1;
        this.uniqueItemWeight = 0;
        this.runedItemWeight = 0;
        return this;
    }

    public ConfigItem setAlwaysRuned() {
        this.normalItemWeight = 0;
        this.uniqueItemWeight = 0;
        this.runedItemWeight = 1;
        return this;
    }

    public ConfigItem setAlwaysUnique() {
        this.normalItemWeight = 0;
        this.uniqueItemWeight = 1;
        this.runedItemWeight = 0;
        return this;
    }

    public ConfigItem setGenerationWeights(int normalItemWeight, int runedItemWeight, int uniqueItemWeight) {
        this.normalItemWeight = normalItemWeight;
        this.uniqueItemWeight = uniqueItemWeight;
        this.runedItemWeight = runedItemWeight;
        return this;
    }

    public ConfigItem setType(GearItemSlot type) {
        this.itemType = type.GUID();
        return this;
    }

    public ConfigItem setType(String type) {
        this.itemType = type;
        return this;
    }

    public ConfigItem setDropWeight(int weight) {
        this.dropWeight = weight;
        return this;
    }

    public ConfigItem setMinRarity(int rar) {
        this.minRarity = rar;
        return this;
    }

    public ConfigItem setMaxRarity(int rar) {
        this.maxRarity = rar;
        return this;
    }

    public ConfigItem setSalvagable(boolean bool) {
        this.isSalvagable = bool;
        return this;
    }

    public ConfigItem setMinLevel(int rar) {
        this.minLevel = rar;
        return this;
    }

    public ConfigItem setMaxLevel(int rar) {
        this.maxLevel = rar;
        return this;
    }

    public boolean isValid() throws Exception {
        if (!this.uniqueIsRandom) {
            boolean matches = false;
            for (IUnique uniq : IUnique.getAll()) {
                if (!uniq.GUID().equals(this.uniqueId)) continue;
                matches = true;
            }
            if (!matches) {
                System.out.println("Unique Id doesn't exist");
                return false;
            }
        }
        boolean matchtype = false;
        for (GearItemSlot slot : GearTypes.All.values()) {
            if (!slot.GUID().equals(this.itemType)) continue;
            matchtype = true;
        }
        if (!matchtype) {
            System.out.println("Gear Type doesn't exist");
            return false;
        }
        if (this.normalItemWeight < 1 && this.runedItemWeight < 1 && this.uniqueItemWeight < 1) {
            System.out.println("Weights can't all be 0");
            return false;
        }
        return true;
    }

    public ItemStack create(ItemStack stack, int level) {
        level = this.getLevel(level);
        switch (this.getCreationType()) {
            case NORMAL: {
                this.createNormal(stack, level);
                break;
            }
            case UNIQUE: {
                this.createUnique(stack, level);
                break;
            }
            case RUNED: {
                this.createRuned(stack, level);
            }
        }
        return stack;
    }

    private creationTypes getCreationType() {
        WeightedType result = (WeightedType)RandomUtils.WeightedRandom(Arrays.asList(new WeightedType(this.normalItemWeight, creationTypes.NORMAL), new WeightedType(this.uniqueItemWeight, creationTypes.UNIQUE), new WeightedType(this.runedItemWeight, creationTypes.RUNED)));
        return result.type;
    }

    private int getLevel(int playerlevel) {
        return MathHelper.func_76125_a((int)playerlevel, (int)this.minLevel, (int)this.maxLevel);
    }

    private ItemStack createNormal(ItemStack stack, int level) {
        GearBlueprint blueprint = new GearBlueprint(level);
        blueprint.SetSpecificType(this.itemType);
        blueprint.LevelRange = this.levelVariance > 0;
        blueprint.LevelVariance = this.levelVariance;
        blueprint.minRarity = this.minRarity;
        blueprint.maxRarity = this.maxRarity;
        GearItemData gear = GearGen.CreateData(blueprint);
        gear.isSalvagable = this.isSalvagable;
        gear.isNotFromMyMod = true;
        Gear.Save(stack, gear);
        return stack;
    }

    private ItemStack createUnique(ItemStack stack, int level) {
        UniqueBlueprint blueprint = new UniqueBlueprint(level, this.uniqueId);
        blueprint.uniqueIsRandom = this.uniqueIsRandom;
        blueprint.tier = this.randomUniqueUpToTier;
        blueprint.map_tier = this.randomUniqueUpToTier;
        blueprint.SetSpecificType(this.itemType);
        blueprint.LevelRange = this.levelVariance > 0;
        blueprint.LevelVariance = this.levelVariance;
        GearItemData gear = UniqueGearGen.CreateData(blueprint);
        gear.isSalvagable = this.isSalvagable;
        gear.isNotFromMyMod = true;
        if (gear.uniqueGUID == null || !IUnique.ITEMS.containsKey(gear.uniqueGUID)) {
            return this.createNormal(stack, level);
        }
        Gear.Save(stack, gear);
        return stack;
    }

    private ItemStack createRuned(ItemStack stack, int level) {
        RunedGearBlueprint blueprint = new RunedGearBlueprint(level);
        blueprint.SetSpecificType(this.itemType);
        blueprint.LevelRange = this.levelVariance > 0;
        blueprint.LevelVariance = this.levelVariance;
        blueprint.minRarity = this.minRarity;
        blueprint.maxRarity = this.maxRarity;
        GearItemData gear = RunedGearGen.CreateData(blueprint);
        gear.isSalvagable = this.isSalvagable;
        gear.isNotFromMyMod = true;
        Gear.Save(stack, gear);
        return stack;
    }

    public static enum creationTypes {
        NORMAL,
        RUNED,
        UNIQUE;

    }
}

