/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.config.non_mine_items;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.robertx22.config.non_mine_items.ConfigItems;
import com.robertx22.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.db_lists.GearTypes;
import com.robertx22.items.unique_items.IUnique;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Serialization {
    private static String config_path = "";

    public static void generateConfig(FMLPreInitializationEvent event) {
        config_path = event.getModConfigurationDirectory().getAbsolutePath() + "/" + "mmorpg" + "/";
        new File(config_path).mkdirs();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)new ConfigItems());
        Serialization.makeFileAndDirAndWrite(Serialization.getItemsConfigPath(), json, false);
    }

    public static String getItemsConfigPath() {
        return config_path + "CompatibleItems.txt";
    }

    public static void loadConfig(FMLPreInitializationEvent event) {
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(Serialization.getItemsConfigPath()));
            ConfigItems.INSTANCE = (ConfigItems)new Gson().fromJson(reader, ConfigItems.class);
            System.out.println("Items added to config: " + ConfigItems.INSTANCE.map.size());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void generateConfigTut(FMLPostInitializationEvent event) {
        Serialization.genListOfUniqueItems();
        Serialization.genListOfItemTypes();
    }

    private static void makeFileAndDirAndWrite(String path, String text, boolean overwriteAnyway) {
        try {
            if (!new File(path).exists() || overwriteAnyway) {
                new File(path).createNewFile();
                FileWriter fileWriter = new FileWriter(path);
                fileWriter.write(text);
                fileWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void genListOfUniqueItems() {
        ArrayList<String> list = new ArrayList<String>();
        for (Item item : IUnique.ITEMS.values()) {
            IUnique uniq = (IUnique)item;
            list.add(uniq.GUID());
        }
        String text = "// THIS FILE IS A TUTORIAL FILE, IT LETS YOU KNOW THE GUIDS/IDS OF ALL UNIQUE ITEMS\n" + String.join((CharSequence)"\n", list);
        Serialization.makeFileAndDirAndWrite(config_path + "UniqueItemGUIDS-TUTORIAL.txt", text, true);
    }

    private static void genListOfItemTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (GearItemSlot item : GearTypes.All.values()) {
            list.add(item.GUID());
        }
        String text = "// THIS FILE IS A TUTORIAL FILE, IT LETS YOU KNOW WHAT ITEM TYPES THERE ARE\n" + String.join((CharSequence)"\n", list);
        Serialization.makeFileAndDirAndWrite(config_path + "GearTypeGUIDS-TUTORIAL.txt", text, true);
    }
}

