/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.database.runewords;

import com.robertx22.database.stats.StatMod;
import com.robertx22.items.runes.base.BaseRuneItem;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.utilityclasses.IWeighted;
import java.util.List;

public abstract class RuneWord
implements IWeighted {
    public abstract List<StatMod> mods();

    public abstract String GUID();

    public abstract String unlocName();

    public String locName() {
        return CLOC.word(this.unlocName());
    }

    public abstract List<BaseRuneItem> runes();

    public int size() {
        return this.runes().size();
    }

    @Override
    public int Weight() {
        return 1000;
    }

    public String getRuneWordCombo() {
        String text = "";
        for (BaseRuneItem item : this.runes()) {
            text = text + item.name().toUpperCase();
        }
        return text;
    }

    public String getRuneWordComboString() {
        String text = "";
        for (BaseRuneItem item : this.runes()) {
            text = text + item.name().toUpperCase() + " + ";
        }
        text = text.substring(0, text.length() - 3);
        return text;
    }

    public boolean runesMatch(String word) {
        return this.getRuneWordCombo().equals(word);
    }
}

