/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dimensions;

import com.robertx22.loot.MasterLootGen;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ChestGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        WorldData.IWorldData data = Load.World((ICapabilityProvider)world);
        if (data != null && data.isMapWorld() && RandomUtils.roll(1.0f)) {
            List<ItemStack> loot = MasterLootGen.gen(2.0f, data, data.getLevel());
            while (loot.size() < 2) {
                for (ItemStack stack : MasterLootGen.gen(1.0f, data, data.getLevel())) {
                    loot.add(stack);
                }
            }
            int x = chunkX * 16 + random.nextInt(8);
            int z = chunkZ * 16 + random.nextInt(8);
            BlockPos pos1 = new BlockPos(x, 0, z);
            int y = world.func_175672_r(pos1).func_177956_o();
            BlockPos pos = new BlockPos(x, y, z);
            this.genChest(world, pos, loot);
        }
    }

    private void genChest(World world, BlockPos pos, List<ItemStack> items) {
        TileEntityChest chest = new TileEntityChest();
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (items.size() <= i) continue;
            chest.func_70299_a(i, items.get(i));
        }
        world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
        world.func_175690_a(pos, (TileEntity)chest);
    }
}

