/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dimensions;

import java.io.File;
import java.io.FileFilter;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldFileUtils {
    private static final FileFilter FILE_FILTER_NO_LEVEL = new FileFilter(){

        @Override
        public boolean accept(File name) {
            return !name.getName().equals("level.dat");
        }
    };

    @Nullable
    public static File getWorldDirectory(World world) {
        IChunkProvider chunkProvider = world.func_72863_F();
        if (chunkProvider instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)chunkProvider;
            IChunkLoader chunkLoader = chunkProviderServer.field_73247_e;
            if (chunkLoader instanceof AnvilChunkLoader) {
                return ((AnvilChunkLoader)chunkLoader).field_75825_d;
            }
            return null;
        }
        return WorldFileUtils.getWorldDirectoryDirectly(world, true);
    }

    private static File getWorldDirectoryDirectly(World world, boolean mkDirs) {
        File mainWorldDir;
        File dimensionDir = mainWorldDir = world.func_72860_G().func_75765_b();
        String dimensionDirName = world.field_73011_w.getSaveFolder();
        if (dimensionDirName != null) {
            dimensionDir = new File(mainWorldDir, dimensionDirName);
            if (mkDirs) {
                dimensionDir.mkdirs();
            }
        }
        return dimensionDir;
    }
}

