/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.generation.blueprints;

import com.robertx22.database.rarities.MapRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.generation.RarityGen;
import com.robertx22.generation.blueprints.ItemBlueprint;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;

public class MapBlueprint
extends ItemBlueprint {
    private int tier = 0;
    private boolean tierRange = true;
    private int tierVariance = 2;
    private static final int MAX_MAP_TIER = 20;

    public MapBlueprint(int level, int worldTier) {
        super(level);
        this.setTier(worldTier);
    }

    public void setTier(int i) {
        this.tier = i;
    }

    public int getTier() {
        if (this.tierRange) {
            int thetier = RandomUtils.RandomRange(this.tier - this.tierVariance, this.tier + this.tierVariance);
            if (thetier < 1) {
                thetier = 1;
            }
            if (thetier > 20) {
                thetier = 20;
            }
            return thetier;
        }
        return this.tier;
    }

    @Override
    public int GetRarity() {
        if (this.RandomRarity) {
            if (this.minRarity > -1) {
                MapRarity rar = Rarities.Maps.get(RarityGen.Random(0, ListUtils.CollectionToList(Rarities.Maps)).Rank());
                while (rar.Rank() < this.minRarity) {
                    rar = Rarities.Maps.get(RarityGen.Random(0, ListUtils.CollectionToList(Rarities.Maps)).Rank());
                }
                return rar.Rank();
            }
            return RarityGen.Random(0, ListUtils.CollectionToList(Rarities.Maps)).Rank();
        }
        return this.rarity;
    }
}

