/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.items.bags;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.db_lists.CreativeTabList;
import com.robertx22.db_lists.Rarities;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.ISalvagable;
import com.robertx22.saveclasses.MapItemData;
import com.robertx22.saveclasses.SpellItemData;
import com.robertx22.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.saveclasses.rune.RuneItemData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.datasaving.Gear;
import com.robertx22.uncommon.datasaving.Map;
import com.robertx22.uncommon.datasaving.Rune;
import com.robertx22.uncommon.datasaving.Spell;
import com.robertx22.uncommon.utilityclasses.RegisterItemUtils;
import com.robertx22.uncommon.utilityclasses.RegisterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class AutoSalvageBag
extends Item
implements IBauble {
    public static HashMap<Integer, Item> Items = new HashMap();
    public int rarity = 0;
    private final int defaul_gear_rarity_salvage = 0;
    private final int default_spell_rarity_salvage = 0;
    private final int default_map_rarity_salvage = -1;
    private final int default_rune_rarity_salvage = 1;
    private List<Float> BonusSalvageValues = Arrays.asList(Float.valueOf(5.0f), Float.valueOf(10.0f), Float.valueOf(20.0f), Float.valueOf(30.0f), Float.valueOf(40.0f), Float.valueOf(50.0f), Float.valueOf(100.0f));

    public AutoSalvageBag(int rarity) {
        this.rarity = rarity;
        this.func_77656_e(0);
        this.func_77637_a(CreativeTabList.MyModTab);
        RegisterItemUtils.RegisterItemName(this, "auto_salvage_bag" + rarity);
    }

    public float getBonusSalvageChance() {
        return this.BonusSalvageValues.get(this.rarity).floatValue();
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack stack;
            ItemStack bag = player.func_184586_b(hand);
            NBTTagCompound nbt = bag.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if ((stack = player.func_184592_cb()) != null && !stack.func_190926_b()) {
                RuneItemData rune;
                MapItemData map;
                SpellItemData spell;
                GearItemData gear = Gear.Load(stack);
                if (gear != null) {
                    nbt.func_74768_a("gear", gear.Rarity);
                    this.successChat(player);
                }
                if ((spell = Spell.Load(stack)) != null) {
                    nbt.func_74768_a("spell", spell.rarity);
                    this.successChat(player);
                }
                if ((map = Map.Load(stack)) != null) {
                    nbt.func_74768_a("map", map.rarity);
                    this.successChat(player);
                }
                if ((rune = Rune.Load(stack)) != null) {
                    nbt.func_74768_a("rune", rune.rarity);
                    this.successChat(player);
                }
                bag.func_77982_d(nbt);
            } else {
                nbt.func_74768_a("gear", -1);
                nbt.func_74768_a("spell", -1);
                nbt.func_74768_a("map", -1);
                nbt.func_74768_a("rune", -1);
                player.func_145747_a((ITextComponent)new TextComponentString("Bag Config Cleared"));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    private void successChat(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("You Have Successfully Modified your Automatic Salvaging Bag."));
    }

    public ItemStack getSalvageResultForItem(ISalvagable sal) {
        float salvageBonus = this.getBonusSalvageChance();
        return sal.getSalvageResult(salvageBonus);
    }

    public static ISalvagable getSalvagable(ItemStack st) {
        GearItemData gear = Gear.Load(st);
        if (gear != null && !gear.isUnique) {
            return gear;
        }
        SpellItemData spell = Spell.Load(st);
        if (spell != null) {
            return spell;
        }
        MapItemData map = Map.Load(st);
        if (map != null) {
            return map;
        }
        RuneItemData rune = Rune.Load(st);
        if (rune != null) {
            return rune;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        tooltip.add(CLOC.tooltip("auto_salvage_items") + "!");
        tooltip.add("");
        tooltip.add(TextFormatting.YELLOW + CLOC.word("gears") + ":");
        tooltip.add(this.getSalvagedRarities(new ArrayList<Rarity>(Rarities.Items), this.getGear(nbt)));
        tooltip.add(TextFormatting.YELLOW + CLOC.word("spells") + ":");
        tooltip.add(this.getSalvagedRarities(new ArrayList<Rarity>(Rarities.Spells), this.getSpell(nbt)));
        tooltip.add(TextFormatting.YELLOW + CLOC.word("maps") + ":");
        tooltip.add(this.getSalvagedRarities(new ArrayList<Rarity>(Rarities.Maps), this.getMap(nbt)));
        tooltip.add(TextFormatting.YELLOW + CLOC.word("runes") + ":");
        tooltip.add(this.getSalvagedRarities(new ArrayList<Rarity>(Rarities.Runes), this.getRune(nbt)));
        tooltip.add("");
        tooltip.add(CLOC.tooltip("bonus_salvage_chance") + ": " + this.getBonusSalvageChance() + "%");
        tooltip.add("");
        tooltip.add(CLOC.tooltip("works_when_in_baubles_slot"));
        tooltip.add("");
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.GREEN + CLOC.tooltip("sal_info"));
        } else {
            tooltip.add(CLOC.tooltip("sal1"));
            tooltip.add(CLOC.tooltip("sal2"));
            tooltip.add(CLOC.tooltip("sal3"));
            tooltip.add(CLOC.tooltip("sal4"));
            tooltip.add(CLOC.tooltip("sal5"));
        }
    }

    public String getSalvagedRarities(List<Rarity> rarities, int rarity) {
        String text = "";
        for (ItemRarity rar : Rarities.Items) {
            if (rar.Rank() > rarity) continue;
            if (text.length() > 0) {
                text = text + TextFormatting.GRAY + ", ";
            }
            text = text + rar.Color() + rar.locName();
        }
        if (text.length() == 0) {
            text = text + CLOC.word("none");
        }
        return text;
    }

    public boolean shouldSalvageItem(ISalvagable sal, NBTTagCompound nbt) {
        int rarity = sal.getSalvagedRarity();
        return sal instanceof GearItemData ? rarity <= this.getGear(nbt) : (sal instanceof SpellItemData ? rarity <= this.getSpell(nbt) : (sal instanceof MapItemData ? rarity <= this.getMap(nbt) : sal instanceof RuneItemData && rarity <= this.getRune(nbt)));
    }

    private int getGear(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("gear")) {
            return nbt.func_74762_e("gear");
        }
        ((Object)((Object)this)).getClass();
        return 0;
    }

    private int getSpell(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("spell")) {
            return nbt.func_74762_e("spell");
        }
        ((Object)((Object)this)).getClass();
        return 0;
    }

    private int getRune(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("rune")) {
            return nbt.func_74762_e("rune");
        }
        return this.default_rune_rarity_salvage;
    }

    private int getMap(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("map")) {
            return nbt.func_74762_e("map");
        }
        return this.default_map_rarity_salvage;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPickupItem(EntityItemPickupEvent event) {
        if (event.getEntityPlayer() != null) {
            EntityPlayer player = event.getEntityPlayer();
            if (!player.field_70170_p.field_72995_K) {
                ItemStack stack = event.getItem().func_92059_d();
                IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
                for (int a = 0; a < handler.getSlots(); ++a) {
                    if (handler.getStackInSlot(a).func_190926_b() || !(handler.getStackInSlot(a).func_77973_b() instanceof AutoSalvageBag)) continue;
                    AutoSalvageBag salvageBag = (AutoSalvageBag)handler.getStackInSlot(a).func_77973_b();
                    ISalvagable sal = AutoSalvageBag.getSalvagable(stack);
                    if (sal != null && salvageBag.shouldSalvageItem(sal, handler.getStackInSlot(a).func_77978_p())) {
                        ItemStack result = salvageBag.getSalvageResultForItem(sal);
                        stack.func_190920_e(0);
                        EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, result);
                        item.func_174868_q();
                        player.field_70170_p.func_72838_d((Entity)item);
                    }
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Rarities.Items.forEach(x -> Items.put(x.Rank(), new AutoSalvageBag(x.Rank())));
        Items.values().forEach(x -> event.getRegistry().register((IForgeRegistryEntry)x));
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        Items.values().forEach(x -> RegisterUtils.registerRender(x));
    }
}

