/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.items.bags;

import com.robertx22.db_lists.CreativeTabList;
import com.robertx22.mmorpg.Main;
import com.robertx22.uncommon.utilityclasses.RegisterItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

@Mod.EventBusSubscriber
public abstract class BaseBagItem
extends Item {
    public static int size = 54;
    private static final String TAG_ITEMS = "InvItems";

    public abstract int GuiNumber();

    public abstract boolean IsValidItem(ItemStack var1);

    public BaseBagItem(String name) {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabList.MyModTab);
        RegisterItemUtils.RegisterItemName(this, name);
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound oldCapNbt) {
        return new InvProvider();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(TAG_ITEMS)) {
            NBTTagList oldData = stack.func_77978_p().func_150295_c(TAG_ITEMS, 10);
            IItemHandler newInv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)newInv, null, (NBTBase)oldData);
            stack.func_77978_p().func_82580_o(TAG_ITEMS);
            if (stack.func_77978_p().func_186856_d() == 0) {
                stack.func_77982_d(null);
            }
        }
    }

    @SubscribeEvent
    public static void onPickupItem(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (stack.func_190926_b()) {
            return;
        }
        for (int i = 0; i < event.getEntityPlayer().field_71071_by.func_70302_i_(); ++i) {
            ItemStack bag;
            if (i == event.getEntityPlayer().field_71071_by.field_70461_c || (bag = event.getEntityPlayer().field_71071_by.func_70301_a(i)).func_190926_b() || !(bag.func_77973_b() instanceof BaseBagItem)) continue;
            IItemHandler bagInv = (IItemHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            BaseBagItem bagitem = (BaseBagItem)bag.func_77973_b();
            if (!bagitem.IsValidItem(stack) || stack.func_190916_E() <= 0) continue;
            for (int x = 0; x < bagInv.getSlots(); ++x) {
                ItemStack result = bagInv.insertItem(x, stack, false);
                int numPickedUp = stack.func_190916_E() - result.func_190916_E();
                event.getItem().func_92058_a(result);
                if (numPickedUp <= 0) continue;
                event.setCanceled(true);
                if (!event.getItem().func_174814_R()) {
                    event.getItem().field_70170_p.func_184148_a(null, event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((event.getItem().field_70170_p.field_73012_v.nextFloat() - event.getItem().field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                ((EntityPlayerMP)event.getEntityPlayer()).field_71135_a.func_147359_a((Packet)new SPacketCollectItem(event.getItem().func_145782_y(), event.getEntityPlayer().func_145782_y(), numPickedUp));
                event.getEntityPlayer().field_71070_bA.func_75142_b();
                return;
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.openGui((Object)Main.instance, this.GuiNumber(), world, hand == EnumHand.OFF_HAND ? 1 : 0, 0, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xs, float ys, float zs) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            if (!world.field_72995_K) {
                IItemHandler tileInv = null;
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
                    tileInv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
                } else if (tile instanceof IInventory) {
                    tileInv = new InvWrapper((IInventory)tile);
                }
                if (tileInv == null) {
                    return EnumActionResult.FAIL;
                }
                IItemHandlerModifiable bagInv = (IItemHandlerModifiable)player.func_184586_b(hand).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < bagInv.getSlots(); ++i) {
                    ItemStack flower = bagInv.getStackInSlot(i);
                    bagInv.setStackInSlot(i, ItemHandlerHelper.insertItemStacked((IItemHandler)tileInv, (ItemStack)flower, (boolean)false));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private static class InvProvider
    implements ICapabilitySerializable<NBTBase> {
        private final IItemHandler inv = new ItemStackHandler(size);

        private InvProvider() {
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, nbt);
        }
    }
}

