/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.items.lootboxes;

import com.robertx22.config.ModConfig;
import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.db_lists.CreativeTabList;
import com.robertx22.db_lists.Rarities;
import com.robertx22.generation.GearGen;
import com.robertx22.generation.RunedGearGen;
import com.robertx22.generation.SpellItemGen;
import com.robertx22.generation.blueprints.GearBlueprint;
import com.robertx22.generation.blueprints.RunedGearBlueprint;
import com.robertx22.generation.blueprints.SpellBlueprint;
import com.robertx22.items.BaseItem;
import com.robertx22.items.currency.CurrencyItem;
import com.robertx22.loot.gens.CompatibleItemLootGen;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.utilityclasses.IWeighted;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import com.robertx22.uncommon.utilityclasses.RegisterUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ItemLootbox
extends BaseItem
implements IWeighted {
    public static HashMap<String, Item> Items = new HashMap();
    private static HashMap<LootBoxSizes, Integer> ItemAmount = new HashMap<LootBoxSizes, Integer>(){
        {
            this.put(LootBoxSizes.Small, 2);
            this.put(LootBoxSizes.Medium, 4);
            this.put(LootBoxSizes.Big, 6);
        }
    };
    public int weight = 1;
    public LootBoxSizes size;
    public int rarity;
    public LootTypes lootType;

    public static Item GetItem(int rarity, LootTypes type, LootBoxSizes size) {
        String key = ItemLootbox.GetStringForType(rarity, type, size);
        if (Items.containsKey(key)) {
            return Items.get(key);
        }
        return null;
    }

    private static String GetStringForType(int rarity, LootTypes type, LootBoxSizes size) {
        return size.toString() + "_" + type.toString() + "_lootbox_" + rarity;
    }

    public ItemLootbox(LootBoxSizes size, LootTypes type, int rarity) {
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.func_77637_a(CreativeTabList.LootboxTab);
        this.func_77655_b(ItemLootbox.GetStringForType(rarity, type, size));
        this.setRegistryName(ItemLootbox.GetStringForType(rarity, type, size));
        this.size = size;
        this.rarity = rarity;
        this.lootType = type;
        Items.put(ItemLootbox.GetStringForType(rarity, type, size), this);
    }

    private void setWeight() {
        int base = Rarities.Items.get(this.rarity).Weight();
        this.weight = base = (int)((float)base * this.size.weightMult);
    }

    private GearType getRandomType() {
        ArrayList<GenWeight> types = new ArrayList<GenWeight>();
        if (ModConfig.Server.USE_COMPATIBILITY_ITEMS) {
            types.add(new GenWeight(GearType.Compatible, (int)ModConfig.DropRates.COMPATIBLE_ITEMS_DROPRATE * 100));
        }
        types.add(new GenWeight(GearType.Runed, (int)ModConfig.DropRates.RUNED_GEAR_DROPRATE * 100));
        types.add(new GenWeight(GearType.Normal, (int)ModConfig.DropRates.GEAR_DROPRATE * 100));
        GenWeight winner = (GenWeight)RandomUtils.WeightedRandom(ListUtils.CollectionToList(types));
        return winner.gen;
    }

    private void GiveItems(EntityPlayer player, int lvl) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.lootType.equals((Object)LootTypes.Gear)) {
            int i = 0;
            while (true) {
                if (i < ItemAmount.get((Object)this.size)) {
                    GearBlueprint print;
                    GearType type = this.getRandomType();
                    if (type.equals((Object)GearType.Compatible)) {
                        stacks.add(CompatibleItemLootGen.gen(lvl));
                    } else if (type.equals((Object)GearType.Runed)) {
                        print = new RunedGearBlueprint(lvl);
                        print.minRarity = this.rarity;
                        print.LevelRange = false;
                        stacks.add(RunedGearGen.CreateStack(print));
                    } else {
                        print = new GearBlueprint(lvl);
                        print.minRarity = this.rarity;
                        print.LevelRange = false;
                        stacks.add(GearGen.CreateStack(print));
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else if (this.lootType.equals((Object)LootTypes.Spell)) {
            SpellBlueprint print = new SpellBlueprint(lvl);
            print.minRarity = this.rarity;
            print.LevelRange = false;
            int i = 0;
            while (true) {
                if (i < ItemAmount.get((Object)this.size)) {
                    stacks.add(SpellItemGen.Create(print));
                    ++i;
                    continue;
                }
                break;
            }
        } else if (this.lootType.equals((Object)LootTypes.Currency)) {
            int i = 0;
            while (true) {
                if (i >= ItemAmount.get((Object)this.size) + this.rarity) break;
                CurrencyItem item = (CurrencyItem)RandomUtils.WeightedRandom(ListUtils.CollectionToList(CurrencyItem.ITEMS));
                stacks.add(new ItemStack((Item)item));
                ++i;
            }
        }
        for (ItemStack stack : stacks) {
            player.func_71019_a(stack, false);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (ItemRarity rarity : Rarities.Items) {
            for (LootTypes type : LootTypes.values()) {
                for (LootBoxSizes size : LootBoxSizes.values()) {
                    new ItemLootbox(size, type, rarity.Rank());
                }
            }
        }
        Items.values().forEach(x -> event.getRegistry().register((IForgeRegistryEntry)x));
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        Items.values().forEach(x -> RegisterUtils.registerRender(x));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        EntityFireworkRocket firework = new EntityFireworkRocket(worldIn);
        firework.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
        worldIn.func_72838_d((Entity)firework);
        if (!worldIn.field_72995_K) {
            try {
                EntityData.UnitData data = Load.Unit((ICapabilityProvider)playerIn);
                if (data != null) {
                    int lvl = data.getLevel();
                    this.GiveItems(playerIn, lvl);
                    return new ActionResult(EnumActionResult.PASS, (Object)this.EmptyOrDecrease(playerIn.func_184586_b(handIn)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public String Name() {
        return "LootBox";
    }

    @Override
    public int Weight() {
        return this.weight;
    }

    static class GenWeight
    implements IWeighted {
        GearType gen = GearType.Normal;
        int weight = 1;

        public GenWeight(GearType gen, int weight) {
            this.gen = gen;
            this.weight = weight;
        }

        @Override
        public int Weight() {
            return this.weight;
        }
    }

    public static enum GearType {
        Runed,
        Normal,
        Compatible;

    }

    public static enum LootBoxSizes {
        Small(2.0f),
        Medium(1.0f),
        Big(0.3f);

        float weightMult;

        private LootBoxSizes(float mult) {
            this.weightMult = mult;
        }
    }

    public static enum LootTypes {
        Gear,
        Spell,
        Currency;

    }
}

