/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.items.misc;

import com.robertx22.database.runewords.RuneWord;
import com.robertx22.db_lists.RuneWords;
import com.robertx22.items.currency.ICurrencyItemEffect;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.datasaving.Gear;
import com.robertx22.uncommon.utilityclasses.RegisterItemUtils;
import com.robertx22.uncommon.utilityclasses.RegisterUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ItemAwakenRuneWord
extends Item
implements ICurrencyItemEffect {
    @GameRegistry.ObjectHolder(value="mmorpg:awaken_runeword")
    public static final Item ITEM = null;

    public ItemAwakenRuneWord() {
        RegisterItemUtils.RegisterItemName(this, "awaken_runeword");
        this.func_77625_d(64);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack != null && RuneWords.All.containsKey(this.getWord(stack))) {
            tooltip.add("");
            tooltip.add(CLOC.word("runeword") + ":");
            String word = this.getWord(stack);
            RuneWord runeword = RuneWords.All.get(word);
            tooltip.add(TextFormatting.GOLD + runeword.locName());
            tooltip.add(TextFormatting.GREEN + runeword.getRuneWordComboString());
            tooltip.add(TextFormatting.AQUA + "Runes: " + runeword.size());
            tooltip.add("");
        }
        tooltip.add(CLOC.tooltip("place_in_modify"));
        tooltip.add(CLOC.tooltip("unlocks_runeword_combo"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)new ItemAwakenRuneWord());
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        RegisterUtils.registerRender(ITEM);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack currency) {
        GearItemData gear;
        if (currency.func_77973_b() instanceof ItemAwakenRuneWord && (gear = Gear.Load(stack)) != null) {
            gear.runes.AwakenRuneWord(this.getWord(currency));
            Gear.Save(stack, gear);
        }
        return stack;
    }

    public void setWord(ItemStack stack, RuneWord word) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74778_a("runeword", word.GUID());
        stack.func_77982_d(nbt);
    }

    public String getWord(ItemStack stack) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("runeword")) {
            return stack.func_77978_p().func_74779_i("runeword");
        }
        return "";
    }

    @Override
    public boolean canItemBeModified(ItemStack item, ItemStack currency) {
        String wordtext;
        GearItemData gear;
        return currency.func_77973_b() instanceof ItemAwakenRuneWord && (gear = Gear.Load(item)) != null && RuneWords.All.containsKey(wordtext = this.getWord(currency)) && gear.isRuned() && gear.runes.canAwakenRuneWord(RuneWords.All.get(wordtext));
    }
}

