/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.items.misc;

import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.dimensions.blocks.MapPortalBlock;
import com.robertx22.dimensions.blocks.TileMapPortal;
import com.robertx22.saveclasses.MapItemData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.mapitem.MapAffixData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.datasaving.Map;
import com.robertx22.uncommon.enumclasses.AffectedEntities;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemMap
extends Item {
    public static HashMap<Integer, Item> Items = new HashMap();

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        MapItemData data = Map.Load(stack);
        ItemMap.showTooltip(data, tooltip);
    }

    public static List<String> showTooltip(MapItemData data, List<String> tooltip) {
        if (data != null) {
            ItemRarity rarity = Rarities.Items.get(data.rarity);
            tooltip.add(TextFormatting.YELLOW + CLOC.word("level") + ": " + data.level);
            tooltip.add("");
            ItemMap.addAffixTypeToTooltip(data, tooltip, AffectedEntities.Mobs);
            ItemMap.addAffixTypeToTooltip(data, tooltip, AffectedEntities.Players);
            ItemMap.addAffixTypeToTooltip(data, tooltip, AffectedEntities.All);
            tooltip.add("");
            try {
                tooltip.add(TextFormatting.BLUE + CLOC.word("world_type") + ": " + data.getWorldProvider().locName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tooltip.add("");
            tooltip.add(TextFormatting.GOLD + CLOC.word("tier") + ": " + data.tier);
            tooltip.add("");
            tooltip.add(TextFormatting.GREEN + CLOC.word("minutes") + ": " + data.minutes);
            tooltip.add("");
            tooltip.add(TextFormatting.YELLOW + CLOC.word("bonus_loot_amount") + ": " + data.getBonusLootAmount() + "%");
            tooltip.add("");
            tooltip.add(rarity.Color() + CLOC.word("rarity") + ": " + rarity.locName());
            tooltip.add("");
            tooltip.add(TextFormatting.BLUE + CLOC.tooltip("put_in_mapdevice"));
        }
        return tooltip;
    }

    private static void addAffixTypeToTooltip(MapItemData data, List<String> tooltip, AffectedEntities affected) {
        List<MapAffixData> affixes = data.getAllAffixesThatAffect(affected);
        if (affixes.size() == 0) {
            return;
        }
        String str = "";
        if (affected.equals((Object)AffectedEntities.Players)) {
            str = CLOC.word("player_affixes");
        } else if (affected.equals((Object)AffectedEntities.Mobs)) {
            str = CLOC.word("mob_affixes");
        }
        tooltip.add(TextFormatting.GREEN + str);
        for (MapAffixData affix : affixes) {
            for (StatModData statmod : affix.getAffix().Stats(affix.percent)) {
                for (String statstring : statmod.GetTooltipString(Rarities.Maps.get(data.rarity).StatPercents(), data.level, false)) {
                    tooltip.add(" * " + TextFormatting.RED + statstring);
                }
            }
        }
    }

    public static void createMap(int id, BlockPos pos, World world, MapItemData data) {
        WorldData.IWorldData currentdata = Load.World((ICapabilityProvider)world);
        if (!currentdata.isMapWorld() && data != null) {
            ItemMap.summonPortal(world, pos, id);
        }
    }

    private static void summonPortal(World world, BlockPos pos, int id) {
        ItemMap.spawnPortalBlock(world, pos, id);
        ItemMap.spawnFrameBlock(world, pos.func_177968_d());
        ItemMap.spawnFrameBlock(world, pos.func_177978_c());
        ItemMap.spawnFrameBlock(world, pos.func_177974_f());
        ItemMap.spawnFrameBlock(world, pos.func_177976_e());
        ItemMap.spawnFrameBlock(world, pos.func_177968_d().func_177974_f());
        ItemMap.spawnFrameBlock(world, pos.func_177968_d().func_177976_e());
        ItemMap.spawnFrameBlock(world, pos.func_177978_c().func_177974_f());
        ItemMap.spawnFrameBlock(world, pos.func_177978_c().func_177976_e());
    }

    private static void spawnPortalBlock(World world, BlockPos pos, int id) {
        world.func_180501_a(pos, MapPortalBlock.BLOCK.func_176223_P(), 2);
        TileMapPortal portal = new TileMapPortal(id);
        world.func_175690_a(pos, (TileEntity)portal);
    }

    private static void spawnFrameBlock(World world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150347_e.func_176223_P(), 2);
    }
}

