/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.network;

import com.robertx22.database.particle_gens.ParticleGen;
import com.robertx22.db_lists.ParticleGens;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ParticlePackage
implements IMessage {
    private String name;
    private double x;
    private double y;
    private double z;
    private double xVel;
    private double yVel;
    private double zVel;
    private boolean isGenerator;
    private double radius;
    private int amount;

    public ParticlePackage() {
    }

    public ParticlePackage(boolean isGen, String name, double x, double y, double z, double xVel, double yVel, double zVel, double radius, int amount) {
        this.isGenerator = isGen;
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xVel = xVel;
        this.yVel = yVel;
        this.zVel = zVel;
        this.radius = radius;
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.isGenerator = tag.func_74767_n("isGen");
        this.name = tag.func_74779_i("name");
        this.x = tag.func_74769_h("x");
        this.y = tag.func_74769_h("y");
        this.z = tag.func_74769_h("z");
        this.xVel = tag.func_74769_h("xVel");
        this.yVel = tag.func_74769_h("yVel");
        this.zVel = tag.func_74769_h("zVel");
        this.radius = tag.func_74769_h("radius");
        this.amount = tag.func_74762_e("amount");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("isGen", this.isGenerator);
        tag.func_74778_a("name", this.name);
        tag.func_74780_a("x", this.x);
        tag.func_74780_a("y", this.y);
        tag.func_74780_a("z", this.z);
        tag.func_74780_a("xVel", this.xVel);
        tag.func_74780_a("yVel", this.yVel);
        tag.func_74780_a("zVel", this.zVel);
        tag.func_74780_a("radius", this.radius);
        tag.func_74768_a("amount", this.amount);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<ParticlePackage, IMessage> {
        public IMessage onMessage(final ParticlePackage message, MessageContext ctx) {
            Runnable noteThread = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (message.isGenerator) {
                            ParticleGen gen = ParticleGens.All.get(message.name);
                            gen.Summon(message.x, message.y, message.z, message.xVel, message.yVel, message.zVel, message.radius, message.amount);
                        } else {
                            EnumParticleTypes particle = EnumParticleTypes.func_186831_a((String)message.name);
                            WorldClient world = Minecraft.func_71410_x().field_71441_e;
                            world.func_175688_a(particle, message.x, message.y, message.z, message.xVel, message.yVel, message.zVel, new int[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            noteThread.run();
            return null;
        }
    }
}

