/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.onevent;

import com.robertx22.db_lists.Rarities;
import com.robertx22.loot.LootUtils;
import com.robertx22.loot.MasterLootGen;
import com.robertx22.mmorpg.Main;
import com.robertx22.network.DamageNumberPackage;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.effectdatas.DamageEffect;
import com.robertx22.uncommon.enumclasses.Elements;
import com.robertx22.uncommon.utilityclasses.EntityTypeUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class OnMobDeathDrops {
    @SubscribeEvent
    public static void mobOnDeathDrop(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        try {
            EntityLivingBase entity = event.getEntityLiving();
            if (!(entity instanceof EntityPlayer) && event.getSource().func_76346_g() instanceof EntityPlayer && entity.hasCapability(EntityData.Data, null)) {
                float loot_multi = EntityTypeUtils.getLootMulti((Entity)entity);
                float exp_multi = EntityTypeUtils.getExpMulti((Entity)entity);
                EntityData.UnitData victim = (EntityData.UnitData)entity.getCapability(EntityData.Data, null);
                EntityData.UnitData killer = (EntityData.UnitData)event.getSource().func_76346_g().getCapability(EntityData.Data, null);
                if (!victim.shouldDropLoot(entity)) {
                    return;
                }
                if (loot_multi > 0.0f) {
                    WorldData.IWorldData world = Load.World((ICapabilityProvider)entity.field_70170_p);
                    killer.onMobKill(world);
                    MasterLootGen.genAndDrop(victim, killer, world, entity);
                }
                if (exp_multi > 0.0f) {
                    int exp = OnMobDeathDrops.GiveExp((EntityLivingBase)event.getSource().func_76346_g(), killer, victim, exp_multi);
                    DamageNumberPackage packet = new DamageNumberPackage(entity, Elements.Nature, "+" + DamageEffect.FormatNumber(exp) + " Exp!");
                    packet.isExp = true;
                    Main.Network.sendTo((IMessage)packet, (EntityPlayerMP)event.getSource().func_76346_g());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int GiveExp(EntityLivingBase entity, EntityData.UnitData player, EntityData.UnitData mob, float multi) {
        int exp = (int)((float)mob.getLevel() * Rarities.Mobs.get(mob.getRarity()).ExpOnKill() * multi);
        exp = (int)LootUtils.ApplyLevelDistancePunishment(mob, player, exp);
        exp = player.PostGiveExpEvent((EntityPlayer)entity, exp);
        return exp;
    }
}

