/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.onevent.tickevent;

import com.robertx22.config.ModConfig;
import com.robertx22.database.stat_types.resources.EnergyRegen;
import com.robertx22.database.stat_types.resources.HealthRegen;
import com.robertx22.database.stat_types.resources.ManaRegen;
import com.robertx22.items.misc.ItemMapBackPortal;
import com.robertx22.mmorpg.Main;
import com.robertx22.network.WorldPackage;
import com.robertx22.saveclasses.Unit;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class OnTickLogic {
    static final int TicksToUpdatePlayer = 18;
    static final int TicksToRegen = ModConfig.BasePlayerStats.ticks_regen;
    static final int TicksToGiveMapPortal = 400;
    static final int TicksToUpdateWorld = 120;
    public static HashMap<UUID, PlayerTickData> PlayerTickDatas = new HashMap();

    @SubscribeEvent
    public static void onTickLogic(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            try {
                for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    WorldData.IWorldData mapdata;
                    PlayerTickData data = null;
                    data = PlayerTickDatas.containsKey(player.func_110124_au()) ? PlayerTickDatas.get(player.func_110124_au()) : new PlayerTickData();
                    data.increment();
                    if (data.regenTicks > TicksToRegen) {
                        data.regenTicks = 0;
                        if (player.func_70089_S()) {
                            mapdata = Load.World((ICapabilityProvider)player.field_70170_p);
                            EntityData.UnitData unit_capa = (EntityData.UnitData)player.getCapability(EntityData.Data, null);
                            unit_capa.recalculateStats((EntityLivingBase)player, mapdata);
                            Unit unit = unit_capa.getUnit();
                            int manarestored = (int)unit.MyStats.get((Object)new ManaRegen().Guid()).Value;
                            unit_capa.restoreMana(manarestored);
                            int energyrestored = (int)unit.MyStats.get((Object)new EnergyRegen().Guid()).Value;
                            unit_capa.restoreEnergy(energyrestored);
                            int healthrestored = (int)unit.MyStats.get((Object)new HealthRegen().Guid()).Value;
                            unit_capa.heal((EntityLivingBase)player, healthrestored);
                            unit_capa.setUnit(unit, (EntityLivingBase)player);
                        }
                    }
                    if (data.worldUpdateTicks > 120) {
                        data.worldUpdateTicks = 0;
                        mapdata = Load.World((ICapabilityProvider)player.field_70170_p);
                        if (mapdata.isMapWorld()) {
                            Main.Network.sendTo((IMessage)new WorldPackage(mapdata), player);
                        }
                    }
                    if (data.mapPortalTicks > 400) {
                        ItemStack portalitem;
                        data.mapPortalTicks = 0;
                        mapdata = Load.World((ICapabilityProvider)player.field_70170_p);
                        if (mapdata.isMapWorld() && !player.field_71071_by.func_70431_c(portalitem = new ItemStack(ItemMapBackPortal.ITEM))) {
                            player.field_71071_by.func_70441_a(portalitem);
                        }
                    }
                    if (data.playerSyncTick > 18) {
                        data.playerSyncTick = 0;
                        EntityData.UnitData unit_capa = (EntityData.UnitData)player.getCapability(EntityData.Data, null);
                        unit_capa.syncToClient((EntityPlayer)player);
                    }
                    if (data == null) continue;
                    PlayerTickDatas.put(player.func_110124_au(), data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class PlayerTickData {
        public int regenTicks = 0;
        public int playerSyncTick = 0;
        public int mapPortalTicks = 0;
        public int worldUpdateTicks = 0;

        PlayerTickData() {
        }

        public void increment() {
            ++this.regenTicks;
            ++this.playerSyncTick;
            ++this.mapPortalTicks;
            ++this.worldUpdateTicks;
        }
    }
}

