/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.onevent.world;

import com.robertx22.dimensions.WorldFileUtils;
import com.robertx22.uncommon.capability.MapDatas;
import com.robertx22.uncommon.capability.WorldData;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;

@Mod.EventBusSubscriber
public class CheckWorldDelete {
    public static HashMap<Integer, Integer> idAndDeleteAttempts = new HashMap();

    @SubscribeEvent
    public static void onWorldUnload(final WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            try {
                CheckWorldDelete.resetCount(event.getWorld().field_73011_w.getDimension());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            Runnable noteThread = new Runnable(){

                @Override
                public void run() {
                    block3: {
                        int id = 0;
                        try {
                            MapDatas mapdata;
                            WorldData.IWorldData data;
                            World world = event.getWorld();
                            id = world.field_73011_w.getDimension();
                            if (world.hasCapability(WorldData.Data, null) && (data = (WorldData.IWorldData)world.getCapability(WorldData.Data, null)) != null && data.isSetForDelete() && (mapdata = (MapDatas)world.func_175693_T().func_75742_a(MapDatas.class, MapDatas.getLoc())) != null) {
                                mapdata.delete(world.field_73011_w.getDimension());
                                CheckWorldDelete.increaseCount(id);
                                FileUtils.deleteDirectory((File)WorldFileUtils.getWorldDirectory(world));
                                System.out.println("Deleting a temporary map world to free up disk space!");
                            }
                            scheduler.shutdown();
                        }
                        catch (Exception e) {
                            if (!CheckWorldDelete.hasMoreTries(id)) break block3;
                            scheduler.schedule(this, 3L, TimeUnit.SECONDS);
                        }
                    }
                }
            };
            scheduler.schedule(noteThread, 3L, TimeUnit.SECONDS);
        }
    }

    private static boolean hasMoreTries(int id) {
        return !idAndDeleteAttempts.containsKey(id) || idAndDeleteAttempts.get(id) < 5;
    }

    private static void resetCount(int id) {
        if (idAndDeleteAttempts.containsKey(id)) {
            idAndDeleteAttempts.put(id, 0);
        }
    }

    private static void increaseCount(int id) {
        if (idAndDeleteAttempts.containsKey(id)) {
            idAndDeleteAttempts.put(id, idAndDeleteAttempts.get(id) + 1);
        } else {
            idAndDeleteAttempts.put(id, 1);
        }
    }
}

