/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses;

import com.robertx22.config.ModConfig;
import com.robertx22.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.database.rarities.items.UniqueItem;
import com.robertx22.database.stats.StatMod;
import com.robertx22.db_lists.GearTypes;
import com.robertx22.db_lists.Rarities;
import com.robertx22.items.currency.CurrencyItem;
import com.robertx22.items.gearitems.bases.IWeapon;
import com.robertx22.items.ores.ItemOre;
import com.robertx22.items.unique_items.IUnique;
import com.robertx22.saveclasses.ISalvagable;
import com.robertx22.saveclasses.Unit;
import com.robertx22.saveclasses.gearitem.ChaosStatsData;
import com.robertx22.saveclasses.gearitem.GearTypeStatsData;
import com.robertx22.saveclasses.gearitem.InfusionData;
import com.robertx22.saveclasses.gearitem.PrefixData;
import com.robertx22.saveclasses.gearitem.PrimaryStatsData;
import com.robertx22.saveclasses.gearitem.SecondaryStatsData;
import com.robertx22.saveclasses.gearitem.SetData;
import com.robertx22.saveclasses.gearitem.SocketsListData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.SuffixData;
import com.robertx22.saveclasses.gearitem.UniqueStatsData;
import com.robertx22.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltip;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.saveclasses.rune.RunesData;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

@Storable
public class GearItemData
implements ITooltip,
ISalvagable {
    @Store
    public boolean isUnique = false;
    @Store
    public String uniqueGUID;
    @Store
    public int Rarity;
    @Store
    public boolean isNotFromMyMod = false;
    @Store
    public String gearTypeName = "";
    @Store
    public RunesData runes;
    @Store
    public int level;
    @Store
    public UniqueStatsData uniqueStats;
    @Store
    public GearTypeStatsData gearTypeStats;
    @Store
    public PrimaryStatsData primaryStats;
    @Store
    public SecondaryStatsData secondaryStats;
    @Store
    public SuffixData suffix;
    @Store
    public PrefixData prefix;
    @Store
    public SetData set;
    @Store
    public ChaosStatsData chaosStats;
    @Store
    public SocketsListData sockets;
    @Store
    public InfusionData infusion;
    @Store
    public boolean isSalvagable = true;
    @Store
    public int timesLeveledUp = 0;

    public boolean isRuned() {
        return this.runes != null;
    }

    public boolean changesItemStack() {
        return !this.isNotFromMyMod;
    }

    public String name(ItemStack stack) {
        if (this.isUnique) {
            if (IUnique.ITEMS.containsKey(this.uniqueGUID)) {
                return ((IUnique)IUnique.ITEMS.get(this.uniqueGUID)).locName();
            }
            return "error";
        }
        if (this.gearTypeName.isEmpty()) {
            return "error";
        }
        return stack.func_82833_r();
    }

    public boolean isSocketable() {
        return this.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Armor);
    }

    public boolean isUpgradable() {
        return this.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Weapon);
    }

    public boolean isEnchantable() {
        return this.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Jewerly);
    }

    public Item getItem() {
        if (this.isUnique) {
            if (IUnique.ITEMS.containsKey(this.uniqueGUID)) {
                return IUnique.ITEMS.get(this.uniqueGUID);
            }
            return null;
        }
        if (this.gearTypeName.isEmpty()) {
            return Items.field_190931_a;
        }
        return GearTypes.All.get(this.gearTypeName).GetItemForRarity(this.GetRarity().Rank());
    }

    public void WriteOverDataThatShouldStay(GearItemData newdata) {
        newdata.timesLeveledUp = this.timesLeveledUp;
        newdata.isSalvagable = this.isSalvagable;
    }

    public GearItemSlot GetBaseGearType() {
        return GearTypes.All.get(this.gearTypeName);
    }

    public ItemRarity GetRarity() {
        if (this.isUnique) {
            return new UniqueItem();
        }
        return Rarities.Items.get(this.Rarity);
    }

    public String GetDisplayName(ItemStack stack) {
        String text = this.GetRarity().Color();
        if (this.isUnique) {
            IUnique uniq = (IUnique)this.getItem();
            text = text + uniq.locName();
        } else if (this.isRuned()) {
            text = text + "Runed " + this.name(stack);
        } else {
            if (this.prefix != null && ModConfig.Client.SHOW_AFFIXED_NAME) {
                text = text + this.prefix.BaseAffix().locName() + " ";
            }
            text = text + this.name(stack);
            if (this.suffix != null && ModConfig.Client.SHOW_AFFIXED_NAME) {
                text = text + " " + this.suffix.BaseAffix().locName() + " ";
            }
        }
        return text;
    }

    public List<IStatsContainer> GetAllStatContainers() {
        ArrayList<IStatsContainer> list = new ArrayList<IStatsContainer>();
        this.IfNotNullAdd(this.secondaryStats, list);
        this.IfNotNullAdd(this.primaryStats, list);
        this.IfNotNullAdd(this.prefix, list);
        this.IfNotNullAdd(this.suffix, list);
        this.IfNotNullAdd(this.chaosStats, list);
        this.IfNotNullAdd(this.uniqueStats, list);
        this.IfNotNullAdd(this.gearTypeStats, list);
        this.IfNotNullAdd(this.sockets, list);
        this.IfNotNullAdd(this.infusion, list);
        this.IfNotNullAdd(this.runes, list);
        return list;
    }

    public List<IStatsContainer.LevelAndStats> GetAllStats(int level) {
        ArrayList<IStatsContainer.LevelAndStats> datas = new ArrayList<IStatsContainer.LevelAndStats>();
        for (IStatsContainer con : this.GetAllStatContainers()) {
            datas.addAll(con.GetAllStats(this.level));
        }
        return datas;
    }

    public List<StatModData> mergeSameStats(List<StatModData> mods) {
        ArrayList<StatModData> newmods = new ArrayList<StatModData>();
        for (StatModData mod : mods) {
            boolean add = true;
            for (StatModData newmod : newmods) {
                if (!newmod.baseModName.equals(mod.baseModName)) continue;
                newmod.percent += mod.percent;
                add = false;
                break;
            }
            if (!add) continue;
            newmods.add(mod);
        }
        return newmods;
    }

    @Override
    public void BuildTooltip(ItemStack stack, ItemTooltipEvent event, Unit unit, EntityData.UnitData data) {
        event.getToolTip().clear();
        event.getToolTip().add(this.GetDisplayName(stack));
        event.getToolTip().add(TextFormatting.YELLOW + CLOC.word("level") + ": " + this.level);
        event.getToolTip().add("");
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.uniqueStats != null) {
            event.getToolTip().addAll(this.uniqueStats.GetTooltipString(this));
        }
        if (this.primaryStats != null) {
            event.getToolTip().addAll(this.primaryStats.GetTooltipString(this));
        }
        if (this.runes != null) {
            event.getToolTip().addAll(this.runes.GetTooltipString(this));
        }
        event.getToolTip().add("");
        list.add(this.secondaryStats);
        list.add(this.prefix);
        list.add(this.suffix);
        list.add(this.chaosStats);
        list.add(this.gearTypeStats);
        list.add(this.sockets);
        list.add(this.infusion);
        for (ITooltipList iTooltipList : list) {
            if (iTooltipList == null) continue;
            event.getToolTip().addAll(iTooltipList.GetTooltipString(this));
            event.getToolTip().add("");
        }
        this.BuildSetTooltip(event, unit, data);
        if (this.isUnique) {
            IUnique unique = this.uniqueStats.getUniqueItem();
            event.getToolTip().add(TextFormatting.GREEN + "'" + unique.locDesc() + "'");
            event.getToolTip().add("");
        }
        ItemRarity rarity = this.GetRarity();
        event.getToolTip().add(CLOC.word("rarity") + ": " + rarity.Color() + rarity.locName());
        if (!this.isSalvagable) {
            event.getToolTip().add(TextFormatting.RED + CLOC.word("unsalvagable"));
        }
        if (this.GetBaseGearType() instanceof IWeapon) {
            IWeapon iWeapon = (IWeapon)((Object)this.GetBaseGearType());
            event.getToolTip().add("");
            event.getToolTip().add(TextFormatting.GREEN + CLOC.stat("energy") + ": " + iWeapon.mechanic().GetEnergyCost());
        }
        List<String> list2 = this.removeDoubleBlankLines(event.getToolTip());
        event.getToolTip().clear();
        event.getToolTip().addAll(list2);
    }

    private List<String> removeDoubleBlankLines(List<String> tooltip) {
        ArrayList<String> newt = new ArrayList<String>();
        String s = "";
        for (int i = 0; i < tooltip.size(); ++i) {
            if (i > 0) {
                if (!s.equals(tooltip.get(i)) || !s.isEmpty()) {
                    newt.add(tooltip.get(i));
                }
            } else {
                newt.add(tooltip.get(i));
            }
            s = tooltip.get(i);
        }
        return newt;
    }

    private void BuildSetTooltip(ItemTooltipEvent event, Unit unit, EntityData.UnitData data) {
        if (this.set != null) {
            event.getToolTip().add(TextFormatting.GREEN + "[Set]: " + TextFormatting.GRAY + this.set.GetSet().Name());
            for (Map.Entry<Integer, StatMod> entry : this.set.GetSet().AllMods().entrySet()) {
                boolean has = false;
                TextFormatting color = null;
                if (unit.WornSets.containsKey(this.set.baseSet) && unit.WornSets.get(this.set.baseSet) >= entry.getKey()) {
                    color = TextFormatting.GREEN;
                    has = true;
                } else {
                    color = TextFormatting.DARK_GREEN;
                }
                for (String str : StatModData.Load(entry.getValue(), this.set.GetSet().StatPercent).GetTooltipString(this.GetRarity().StatPercents(), data.getLevel(), false)) {
                    String stat = StringUtils.func_76338_a((String)str);
                    String str2 = color + "" + entry.getKey() + " set: " + TextFormatting.DARK_GREEN + stat;
                    event.getToolTip().add(str2);
                }
            }
            event.getToolTip().add("");
        }
    }

    public List<IRerollable> GetAllRerollable() {
        ArrayList<IRerollable> list = new ArrayList<IRerollable>();
        this.IfNotNullAdd(this.secondaryStats, list);
        this.IfNotNullAdd(this.primaryStats, list);
        this.IfNotNullAdd(this.prefix, list);
        this.IfNotNullAdd(this.suffix, list);
        this.IfNotNullAdd(this.chaosStats, list);
        this.IfNotNullAdd(this.uniqueStats, list);
        this.IfNotNullAdd(this.gearTypeStats, list);
        return list;
    }

    private <T> void IfNotNullAdd(T obj, List<T> list) {
        if (obj != null) {
            list.add(obj);
        }
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        if (!this.isSalvagable) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        int tier = 0;
        int min = 1;
        int max = 3;
        min = this.tryIncreaseAmount(salvageBonus, min);
        max = this.tryIncreaseAmount(salvageBonus, max);
        if (this.isUnique) {
            try {
                tier = this.uniqueStats.getUniqueItem().Tier();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (RandomUtils.roll(this.GetRarity().specialItemChance())) {
            Item item = (Item)RandomUtils.WeightedRandom(ListUtils.SameTierOrLess(ListUtils.CollectionToList(CurrencyItem.ITEMS), tier));
            if (this.isUnique) {
                int amount = RandomUtils.RandomRange(min, max + tier / 5);
                stack.func_190920_e(amount);
            }
            stack = new ItemStack(item);
        } else {
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.Rarity);
            stack = new ItemStack((Item)ore);
            stack.func_190920_e(amount);
        }
        return stack;
    }

    @Override
    public int getSalvagedRarity() {
        return this.Rarity;
    }
}

