/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses;

import com.robertx22.config.ModConfig;
import com.robertx22.database.rarities.MapRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.db_lists.WorldProviders;
import com.robertx22.dimensions.IWP;
import com.robertx22.items.currency.CurrencyItem;
import com.robertx22.items.ores.ItemOre;
import com.robertx22.saveclasses.DimensionData;
import com.robertx22.saveclasses.ISalvagable;
import com.robertx22.saveclasses.mapitem.MapAffixData;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.MapDatas;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.enumclasses.AffectedEntities;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@Storable
public class MapItemData
implements ISalvagable {
    @Store
    public int minutes = 30;
    @Store
    public int level = 1;
    @Store
    public int tier = 0;
    @Store
    public int rarity = 0;
    @Store
    public List<MapAffixData> affixes = new ArrayList<MapAffixData>();
    @Store
    public String worldGeneratorName;

    @Override
    public int getSalvagedRarity() {
        return this.rarity;
    }

    public int getBonusLootAmount() {
        return (int)((float)this.getTotalPercents() * 0.5f);
    }

    public int getBonusLootRarity() {
        return (int)((float)this.getTotalPercents() * 0.5f);
    }

    public boolean increaseLevel(int i) {
        int lvl = this.level + i;
        if (lvl > ModConfig.Server.MAXIMUM_PLAYER_LEVEL) {
            return false;
        }
        this.level = lvl;
        return true;
    }

    public boolean increaseTier(int i) {
        int tier = this.tier + i;
        if (tier > 20) {
            return false;
        }
        this.tier = tier;
        return true;
    }

    private int getTotalPercents() {
        int total = 0;
        for (MapAffixData affix : this.affixes) {
            total += affix.percent;
        }
        return total;
    }

    public List<MapAffixData> getAllAffixesThatAffect(AffectedEntities affected) {
        ArrayList<MapAffixData> list = new ArrayList<MapAffixData>();
        for (MapAffixData data : this.affixes) {
            if (!data.affectedEntities.equals((Object)affected)) continue;
            list.add(data);
        }
        return list;
    }

    public IWP getWorldProvider() {
        return WorldProviders.All.get(this.worldGeneratorName);
    }

    public void createDimension(int id, World ogworld, BlockPos pos, EntityPlayer player) {
        EntityData.UnitData unit = Load.Unit((ICapabilityProvider)player);
        MapItemData map = this;
        unit.setCurrentMapId(id);
        DimensionData dimData = this.getDimData(id, map.worldGeneratorName);
        if (DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.unregisterDimension((int)id);
        }
        DimensionManager.registerDimension((int)id, (DimensionType)dimData.getDimensionType());
        DimensionManager.initDimension((int)id);
        WorldServer world = DimensionManager.getWorld((int)id);
        WorldData.IWorldData data = (WorldData.IWorldData)world.getCapability(WorldData.Data, null);
        data.init(pos, ogworld, map, id, player);
        MapDatas mapdatas = (MapDatas)DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(MapDatas.class, MapDatas.getLoc());
        mapdatas.register(dimData);
    }

    private DimensionData getDimData(int id, String worldgen) {
        DimensionData data = new DimensionData("mmorpg_dim", "_map", id, WorldProviders.All.get(worldgen));
        return data;
    }

    public int findFreeDimensionId(EntityPlayer player, EntityData.UnitData unit) {
        int lastid;
        if (unit.hasCurrentMapId() && DimensionManager.isDimensionRegistered((int)(lastid = unit.getCurrentMapId()))) {
            DimensionManager.initDimension((int)lastid);
            WorldServer world = DimensionManager.getWorld((int)lastid);
            if (world != null) {
                WorldData.IWorldData data = Load.World((ICapabilityProvider)world);
                data.setDelete(true, (World)world);
            }
        }
        int id = ModConfig.MapDimensions.MAP_ID_START;
        while (DimensionManager.isDimensionRegistered((int)id)) {
            --id;
        }
        return id;
    }

    public MapRarity GetRarity() {
        return Rarities.Maps.get(this.rarity);
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        int min = this.tryIncreaseAmount(salvageBonus, 1);
        int max = this.tryIncreaseAmount(salvageBonus, 3);
        ItemStack stack = ItemStack.field_190927_a;
        if (RandomUtils.roll(this.GetRarity().specialItemChance())) {
            Item item = (Item)RandomUtils.WeightedRandom(ListUtils.SameTierOrLess(ListUtils.CollectionToList(CurrencyItem.ITEMS), this.tier));
            stack = new ItemStack(item);
        } else {
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.rarity);
            stack = new ItemStack((Item)ore);
            stack.func_190920_e(amount);
        }
        return stack;
    }
}

