/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses;

import com.robertx22.database.rarities.SpellRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.db_lists.Spells;
import com.robertx22.items.currency.CurrencyItem;
import com.robertx22.items.ores.ItemOre;
import com.robertx22.saveclasses.ISalvagable;
import com.robertx22.saveclasses.Unit;
import com.robertx22.spells.bases.BaseSpell;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Storable
public class SpellItemData
implements ISalvagable {
    public static int MIN_MANA_COST_PERCENT = 50;
    public static int MAX_MANA_COST_PERCENT = 100;
    @Store
    public int level = 1;
    @Store
    public String spellGUID;
    @Store
    public int rarity;
    @Store
    public int manaCostPercent = 100;
    @Store
    public int scalingEffectPercent = 100;
    @Store
    public int baseEffectPercent = 100;

    @Override
    public int getSalvagedRarity() {
        return this.rarity;
    }

    public int GetManaCost() {
        return this.GetSpell().ManaCost() * this.manaCostPercent / 100;
    }

    public int GetBaseValue() {
        return 1 + this.GetSpell().BaseValue() * this.level * this.baseEffectPercent / 100;
    }

    public float GetScalingValue() {
        return this.GetSpell().ScalingValue().Multi * (float)this.scalingEffectPercent / 100.0f;
    }

    private int MinScaling() {
        return (int)(this.GetSpell().ScalingValue().Multi * (float)this.getRarity().SpellScalingPercents().Min);
    }

    private int MaxScaling() {
        return (int)(this.GetSpell().ScalingValue().Multi * (float)this.getRarity().SpellScalingPercents().Max);
    }

    private int MinBase() {
        return 1 + this.GetSpell().BaseValue() * this.level * this.getRarity().SpellBasePercents().Min / 100;
    }

    private int MaxBase() {
        return 1 + this.GetSpell().BaseValue() * this.level * this.getRarity().SpellBasePercents().Max / 100;
    }

    private int MinMana() {
        return this.GetSpell().ManaCost() * MIN_MANA_COST_PERCENT / 100;
    }

    private int MaxMana() {
        return this.GetSpell().ManaCost() * MAX_MANA_COST_PERCENT / 100;
    }

    public SpellRarity getRarity() {
        return Rarities.Spells.get(this.rarity);
    }

    public String GetScalingDesc(boolean moreInfo) {
        String text = CLOC.word("scaling_value") + ": " + this.GetSpell().ScalingValue().GetStat().localizedString() + " " + CLOC.word("by") + " : " + (int)(this.GetScalingValue() * 100.0f) + "%";
        if (moreInfo) {
            text = text + " (" + this.MinScaling() + "-" + this.MaxScaling() + ")";
        }
        return text;
    }

    public String GetBaseDesc(boolean moreInfo) {
        String text = CLOC.word("base_value") + ": " + this.GetBaseValue();
        if (moreInfo) {
            text = text + " (" + this.MinBase() + "-" + this.MaxBase() + ")";
        }
        return text;
    }

    public String GetManaDesc(boolean moreInfo) {
        String text = CLOC.word("mana_cost") + ": " + this.GetManaCost();
        if (moreInfo) {
            text = text + " (" + this.MinMana() + "-" + this.MaxMana() + ")";
        }
        return text;
    }

    public int GetDamage(Unit unit) {
        BaseSpell spell = this.GetSpell();
        int basedmg = spell.BaseValue() * this.baseEffectPercent / 100 * this.level;
        int scalingdmg = spell.ScalingValue().GetValue(unit) * this.scalingEffectPercent / 100;
        int total = basedmg + scalingdmg;
        int finalrandom = RandomUtils.RandomRange(1 + total / 2, 2 + total + total / 2);
        return finalrandom;
    }

    public BaseSpell GetSpell() {
        return Spells.All.get(this.spellGUID);
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        int min = this.tryIncreaseAmount(salvageBonus, 1);
        int max = this.tryIncreaseAmount(salvageBonus, 3);
        ItemStack stack = ItemStack.field_190927_a;
        if (RandomUtils.roll(this.getRarity().specialItemChance())) {
            Item item = (Item)RandomUtils.WeightedRandom(ListUtils.SameTierOrLess(ListUtils.CollectionToList(CurrencyItem.ITEMS), 0));
            stack = new ItemStack(item);
        } else {
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.rarity);
            stack = new ItemStack((Item)ore);
            stack.func_190920_e(amount);
        }
        return stack;
    }
}

