/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.gearitem;

import com.robertx22.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.database.stats.StatMod;
import com.robertx22.db_lists.GearTypes;
import com.robertx22.generation.StatGen;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.uncommon.CLOC;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

@Storable
public class GearTypeStatsData
implements ITooltipList,
IRerollable,
IStatsContainer {
    @Store
    public String geartypeGUID;
    @Store
    public List<Integer> percents = new ArrayList<Integer>();

    public GearTypeStatsData() {
    }

    public GearTypeStatsData(String GUID) {
        this.geartypeGUID = GUID;
    }

    @Override
    public void RerollFully(GearItemData gear) {
        this.RerollNumbers(gear);
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.percents.clear();
        for (StatMod mod : this.getGearType().slotTypeStats()) {
            this.percents.add(StatGen.GenPercent(gear.GetRarity()));
        }
    }

    @Override
    public List<String> GetTooltipString(GearItemData gear) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.GREEN + this.getGearType().locName() + " " + CLOC.word("stats") + ": ");
        for (IStatsContainer.LevelAndStats part : this.GetAllStats(gear.level)) {
            for (StatModData data : part.mods) {
                list.addAll(data.GetTooltipString(gear.GetRarity().StatPercents(), part.level, true));
            }
        }
        return list;
    }

    public GearItemSlot getGearType() {
        return GearTypes.All.get(this.geartypeGUID);
    }

    @Override
    public List<IStatsContainer.LevelAndStats> GetAllStats(int level) {
        GearItemSlot slot = this.getGearType();
        ArrayList<StatModData> list = new ArrayList<StatModData>();
        for (int i = 0; i < slot.slotTypeStats().size(); ++i) {
            StatMod mod = slot.slotTypeStats().get(i);
            list.add(StatModData.Load(mod, this.percents.get(i)));
        }
        return Arrays.asList(new IStatsContainer.LevelAndStats(list, level));
    }
}

