/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.gearitem;

import com.robertx22.database.rarities.ItemRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.StatGroupData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.uncommon.CLOC;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;

@Storable
public class SocketData
extends StatGroupData
implements ITooltipList {
    @Store
    int rarity = 0;

    public SocketData() {
    }

    public boolean isEmpty() {
        return this.Mods.size() == 0;
    }

    public SocketData(SocketData socket) {
        this.rarity = socket.rarity;
        this.Mods = socket.Mods;
    }

    public ItemRarity GetRarity() {
        return Rarities.Items.get(this.rarity);
    }

    public String getPrefix() {
        return " ";
    }

    @Override
    public List<String> GetTooltipString(GearItemData gear) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isEmpty()) {
            list.add(this.getPrefix() + CLOC.word("empty") + " " + CLOC.word("socket"));
        } else {
            for (IStatsContainer.LevelAndStats part : this.GetAllStats(gear.level)) {
                for (StatModData data : part.mods) {
                    list.addAll(data.GetTooltipString(gear.GetRarity().StatPercents(), part.level, true));
                }
            }
        }
        return list;
    }
}

