/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.saveclasses.rune;

import com.robertx22.database.rarities.RuneRarity;
import com.robertx22.db_lists.Rarities;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.gearitem.StatGroupData;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.ITooltipList;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Storable
public class InsertedRuneData
extends StatGroupData
implements ITooltipList {
    @Store
    public String usedForRuneWord = "";
    @Store
    public int level = 1;
    @Store
    public String rune;
    @Store
    public int rarity;

    public InsertedRuneData() {
    }

    public InsertedRuneData(int level, String name, List<StatModData> mods, int rarity) {
        this.level = level;
        this.rune = name;
        this.Mods = mods;
        this.rarity = rarity;
    }

    public RuneRarity getRarity() {
        return Rarities.Runes.get(this.rarity);
    }

    @Override
    public List<IStatsContainer.LevelAndStats> GetAllStats(int level) {
        ArrayList<StatModData> list = new ArrayList<StatModData>(this.Mods);
        list.addAll(this.Mods);
        return Arrays.asList(new IStatsContainer.LevelAndStats(list, this.level));
    }

    public int getAveragePercents() {
        int per = 0;
        for (StatModData mod : this.Mods) {
            per += mod.percent;
        }
        return per /= this.Mods.size();
    }

    @Override
    public List<String> GetTooltipString(GearItemData gear) {
        ArrayList<String> list = new ArrayList<String>();
        for (StatModData mod : this.Mods) {
            list.addAll(mod.GetTooltipString(this.getRarity().StatPercents(), this.level, true));
        }
        ArrayList<String> list2 = new ArrayList<String>();
        RuneRarity rar = this.getRarity();
        for (String s : list) {
            list2.add(rar.Color() + this.rune.toUpperCase() + rar.Color() + ": [" + s + rar.Color() + " ]");
        }
        return list2;
    }
}

