/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.bases.projectile;

import com.robertx22.ColoredRedstone;
import com.robertx22.spells.bases.BaseSpellEffect;
import com.robertx22.spells.bases.DamageData;
import com.robertx22.spells.bases.projectile.EntityBaseProjectile;
import com.robertx22.spells.bases.projectile.Targeting;
import com.robertx22.uncommon.effectdatas.SpellBuffEffect;
import com.robertx22.uncommon.effectdatas.interfaces.IBuffableSpell;
import com.robertx22.uncommon.enumclasses.Elements;
import com.robertx22.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityElementalBolt
extends EntityBaseProjectile {
    protected BaseSpellEffect effect;
    protected DamageData data;
    public List<EntityLivingBase> entitiesHit = new ArrayList<EntityLivingBase>();
    int ticks = 0;

    public abstract Elements element();

    public EntityElementalBolt(World worldIn) {
        super(worldIn);
    }

    protected Targeting.TargetType getTargetType() {
        return Targeting.TargetType.ENEMY;
    }

    @Override
    public double radius() {
        return 0.5;
    }

    @Override
    protected void func_70088_a() {
    }

    public void SetReady(BaseSpellEffect effect, DamageData data) {
        this.effect = effect;
        this.data = data;
    }

    public void ifDamageKilledEnemy(EntityLivingBase enemy) {
        if (enemy.func_110143_aJ() <= 0.0f) {
            // empty if block
        }
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (result.field_72308_g != null && result.field_72308_g instanceof EntityLivingBase && this.effect != null && this.data != null) {
            EntityLivingBase living;
            if (this.field_70170_p.field_72995_K) {
                SoundUtils.playSound(this, SoundEvents.field_187543_bD, 0.4f, 0.9f);
            }
            if (!this.entitiesHit.contains(living = (EntityLivingBase)result.field_72308_g)) {
                this.effect.Activate(this.data, living);
                this.ifDamageKilledEnemy(living);
                this.entitiesHit.add(living);
            }
        } else if (this.field_70170_p.field_72995_K) {
            SoundUtils.playSound(this, SoundEvents.field_187550_ag, 0.7f, 0.9f);
        }
        if (!this.field_70170_p.field_72995_K && !this.getBuff().equals((Object)IBuffableSpell.SpellBuffType.Ghost_Projectile)) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            ++this.ticks;
            if (this.ticks > 1) {
                this.ticks = 0;
                ColoredRedstone.SpawnAoeRedstone(this.element(), this, 0.15f, 15);
            }
        }
    }

    @Override
    public void SpawnAndShoot(BaseSpellEffect effect, DamageData data, EntityLivingBase caster) {
        this.spellType = data.spellItem.GetSpell().Type();
        SpellBuffEffect spelleffect = new SpellBuffEffect(caster, this);
        spelleffect.Activate();
        this.ignoreEntity = caster;
        this.thrower = caster;
        Vec3d look = caster.func_70040_Z();
        this.SetReady(effect, data);
        this.func_70107_b(caster.field_70165_t + look.field_72450_a, caster.field_70163_u + look.field_72448_b + 1.3, caster.field_70161_v + look.field_72449_c);
        this.shoot((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, 1.0f, 1.0f);
        this.field_70170_p.func_72838_d((Entity)this);
    }
}

