/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.potion_effects;

import com.robertx22.spells.potion_effects.SpellPotionBase;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SpellCast {
    private SpellPotionBase potion;
    private WeakReference<Entity> applier;
    private WeakReference<Entity> caster;
    private NBTTagCompound data;
    private UUID casterUUID;
    private UUID applierUUID;

    public SpellCast(SpellPotionBase potion, Entity caster) {
        this.potion = potion;
        this.applier = new WeakReference<Entity>(caster);
        this.caster = new WeakReference<Entity>(caster);
        this.data = new NBTTagCompound();
        if (caster instanceof EntityPlayer) {
            this.casterUUID = caster.func_110124_au();
            this.applierUUID = caster.func_110124_au();
        }
    }

    public SpellPotionBase getPotion() {
        return this.potion;
    }

    void updateRefs(World world) {
        if (this.casterUUID != null) {
            this.caster = new WeakReference<EntityPlayer>(world.func_152378_a(this.casterUUID));
        }
        if (this.applierUUID != null) {
            this.applier = new WeakReference<EntityPlayer>(world.func_152378_a(this.applierUUID));
        }
    }

    public Entity getApplier() {
        return (Entity)this.applier.get();
    }

    public Entity getCaster() {
        return (Entity)this.caster.get();
    }
}

