/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.spells.self;

import com.robertx22.database.stat_types.resources.HealthRegen;
import com.robertx22.items.spells.self.ItemSelfRegen;
import com.robertx22.saveclasses.SpellItemData;
import com.robertx22.spells.bases.EffectCalculation;
import com.robertx22.spells.bases.SpellBuffCheck;
import com.robertx22.spells.potion_effects.all.HealthRegenPotion;
import com.robertx22.spells.self.BaseSpellHeal;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.effectdatas.SpellBuffEffect;
import com.robertx22.uncommon.utilityclasses.SoundUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellSelfRegen
extends BaseSpellHeal {
    @Override
    public String GUID() {
        return "spell_self_regen";
    }

    @Override
    public int ManaCost() {
        return 25;
    }

    @Override
    public int BaseValue() {
        return 5;
    }

    @Override
    public EffectCalculation ScalingValue() {
        return new EffectCalculation(HealthRegen.GUID, 0.5f);
    }

    @Override
    public Item SpellItem() {
        return ItemSelfRegen.ITEM;
    }

    @Override
    public String GetDescription(SpellItemData data) {
        return CLOC.tooltip("spell_self_regen");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellItemData data) {
        try {
            if (!world.field_72995_K) {
                SoundUtils.playSoundAtPlayer(caster, SoundEvents.field_187664_bz, 1.0f, 1.0f);
                EntityData.UnitData unit = Load.Unit((ICapabilityProvider)caster);
                int healed = (int)((float)data.GetBaseValue() + data.GetScalingValue() * unit.getUnit().healthData().Value / 100.0f);
                caster.func_70690_d(new PotionEffect((Potion)HealthRegenPotion.INSTANCE, 400, healed));
                SpellBuffCheck check = new SpellBuffCheck(this.Type());
                SpellBuffEffect spelleffect = new SpellBuffEffect((EntityLivingBase)caster, check);
                spelleffect.Activate();
                this.checkSpellBuffs(caster, check);
            } else {
                SpellSelfRegen.spawnHealParticles((EntityLivingBase)caster, 10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

