/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.capability;

import com.robertx22.api.MineAndSlashEvents;
import com.robertx22.config.DimensionConfigs;
import com.robertx22.config.ModConfig;
import com.robertx22.database.rarities.MobRarity;
import com.robertx22.database.stat_types.misc.BonusExp;
import com.robertx22.database.stat_types.offense.PhysicalDamage;
import com.robertx22.db_lists.Rarities;
import com.robertx22.items.gearitems.bases.IWeapon;
import com.robertx22.items.gearitems.bases.WeaponMechanic;
import com.robertx22.mmorpg.Main;
import com.robertx22.network.PlayerUnitPackage;
import com.robertx22.onevent.player.OnLogin;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.MapItemData;
import com.robertx22.saveclasses.PlayerMapKillsData;
import com.robertx22.saveclasses.Unit;
import com.robertx22.uncommon.AttackUtils;
import com.robertx22.uncommon.SLOC;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.capability.bases.ICommonCapability;
import com.robertx22.uncommon.datasaving.Gear;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.effectdatas.DamageEffect;
import com.robertx22.uncommon.enumclasses.EntitySystemChoice;
import com.robertx22.uncommon.utilityclasses.HealthUtils;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class EntityData {
    @CapabilityInject(value=UnitData.class)
    public static final Capability<UnitData> Data = null;
    private static final String LEVEL = "level";
    private static final String RARITY = "rarity";
    private static final String EXP = "exp";
    private static final String UUID = "uuid";
    private static final String NAME = "name";
    private static final String MOB_SAVED_ONCE = "mob_saved_once";
    private static final String UNIT_OBJECT = "unit_object";
    private static final String KILLS_OBJECT = "kils_object";
    private static final String MANA = "current_mana";
    private static final String ENERGY = "current_energy";
    private static final String CURRENT_MAP_ID = "current_map_id";
    private static final String DMG_DONE_BY_NON_PLAYERS = "DMG_DONE_BY_NON_PLAYERS";

    public static class DefaultImpl
    implements UnitData {
        private NBTTagCompound nbt = new NBTTagCompound();
        Unit unit = null;
        PlayerMapKillsData kills = null;
        int level = 1;
        int exp = 0;
        int rarity = 0;
        String uuid = "";
        String name = "";
        int currentMapId = 0;
        float dmgByNonPlayers = 0.0f;
        float energy;
        float mana;

        @Override
        public NBTTagCompound getNBT() {
            this.nbt.func_74776_a(EntityData.MANA, this.mana);
            this.nbt.func_74776_a(EntityData.ENERGY, this.energy);
            this.nbt.func_74768_a(EntityData.LEVEL, this.level);
            this.nbt.func_74768_a(EntityData.EXP, this.exp);
            this.nbt.func_74768_a(EntityData.RARITY, this.rarity);
            this.nbt.func_74776_a(EntityData.DMG_DONE_BY_NON_PLAYERS, this.dmgByNonPlayers);
            this.nbt.func_74778_a(EntityData.UUID, this.uuid);
            this.nbt.func_74778_a(EntityData.NAME, this.name);
            this.nbt.func_74757_a(EntityData.MOB_SAVED_ONCE, true);
            this.nbt.func_74768_a(EntityData.CURRENT_MAP_ID, this.currentMapId);
            if (this.unit != null) {
                NBTTagCompound unitnbt = new NBTTagCompound();
                Writer.write(unitnbt, this.unit);
                this.nbt.func_74782_a(EntityData.UNIT_OBJECT, (NBTBase)unitnbt);
            }
            if (this.kills != null) {
                NBTTagCompound killsnbt = new NBTTagCompound();
                Writer.write(killsnbt, this.kills);
                this.nbt.func_74782_a(EntityData.KILLS_OBJECT, (NBTBase)killsnbt);
            }
            return this.nbt;
        }

        @Override
        public void setNBT(NBTTagCompound value) {
            NBTTagCompound kills_nbt;
            this.nbt = value;
            this.level = value.func_74762_e(EntityData.LEVEL);
            this.exp = value.func_74762_e(EntityData.EXP);
            this.rarity = value.func_74762_e(EntityData.RARITY);
            this.uuid = value.func_74779_i(EntityData.UUID);
            this.name = value.func_74779_i(EntityData.NAME);
            this.energy = value.func_74760_g(EntityData.ENERGY);
            this.dmgByNonPlayers = value.func_74760_g(EntityData.DMG_DONE_BY_NON_PLAYERS);
            this.mana = value.func_74760_g(EntityData.MANA);
            this.currentMapId = value.func_74762_e(EntityData.CURRENT_MAP_ID);
            NBTTagCompound object_nbt = (NBTTagCompound)this.nbt.func_74781_a(EntityData.UNIT_OBJECT);
            if (object_nbt != null) {
                this.unit = new Unit();
                Reader.read(object_nbt, this.unit);
            }
            if ((kills_nbt = (NBTTagCompound)this.nbt.func_74781_a(EntityData.KILLS_OBJECT)) != null) {
                this.kills = new PlayerMapKillsData();
                Reader.read(kills_nbt, this.kills);
            }
        }

        @Override
        public int GetExpRequiredForLevelUp() {
            return DefaultImpl.levelToExp(this.getLevel() + 1);
        }

        public static void testEXPLevelingCurve() {
            int i;
            System.out.println("Old Formula");
            for (i = 1; i < 101; ++i) {
            }
            System.out.println("New Formula");
            for (i = 1; i < 101; ++i) {
                System.out.println("level: " + i + " exp: " + DefaultImpl.levelToExp(i));
            }
        }

        public static int equateXp(double xp) {
            return (int)Math.floor(xp + 340.0 * Math.pow(2.0, xp / 9.0));
        }

        public static int levelToExp(int level) {
            double xp = 0.0;
            for (int i = 1; i < level; ++i) {
                xp += (double)DefaultImpl.equateXp(i);
            }
            return (int)Math.floor(xp / 4.0);
        }

        @Override
        public void SetMobLevelAtSpawn(WorldData.IWorldData data, EntityLivingBase entity) {
            DimensionConfigs config = ModConfig.Dimensions.getAll().getConfig(entity.field_71093_bK);
            int lvl = 1;
            if (data != null && data.isMapWorld()) {
                lvl = data.getLevel();
            } else if (config.SINGLEPLAYER_MOB_SCALING) {
                EntityPlayer player = entity.field_70170_p.func_72890_a((Entity)entity, 4999.0);
                if (player != null) {
                    lvl = ((UnitData)player.getCapability(Data, null)).getLevel();
                }
            } else {
                lvl = DefaultImpl.GetMobLevelByDistanceFromSpawn((Entity)entity, config) + config.MINIMUM_MOB_LEVEL - 1;
            }
            this.level = lvl = MathHelper.func_76125_a((int)lvl, (int)config.MINIMUM_MOB_LEVEL, (int)config.MAXIMUM_MOB_LEVEL);
        }

        public static int GetMobLevelByDistanceFromSpawn(Entity entity, DimensionConfigs config) {
            double distance = entity.field_70170_p.func_175694_M().func_185332_f((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
            int lvl = 1;
            lvl = distance < (double)config.MOB_LEVEL_ONE_AREA ? 1 : (int)(1.0 + distance / (double)config.MOB_LEVEL_PER_DISTANCE);
            return lvl;
        }

        @Override
        public int PostGiveExpEvent(EntityPlayer player, int i) {
            i = (int)((float)i * ModConfig.Server.EXPERIENCE_MULTIPLIER);
            i = (int)((double)i * ((double)this.getUnit().MyStats.get((Object)new BonusExp().GUID()).Value / 100.0 + 1.0));
            MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.GiveExpEvent(player, this, i));
            return i;
        }

        @Override
        public int GiveExp(EntityPlayer player, int i) {
            this.setExp(this.exp + i);
            if (this.exp > this.GetExpRequiredForLevelUp()) {
                if (!ModConfig.Server.LEVEL_UPS_COST_TOKEN && this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
                    this.LevelUp(player);
                }
                return i;
            }
            return i;
        }

        @Override
        public boolean CheckIfCanLevelUp() {
            return this.getExp() >= this.GetExpRequiredForLevelUp();
        }

        public int getRemainingExp() {
            int num = this.getExp() - this.GetExpRequiredForLevelUp();
            if (num < 0) {
                num = 0;
            }
            return num;
        }

        @Override
        public boolean CheckLevelCap() {
            return this.getLevel() + 1 <= ModConfig.Server.MAXIMUM_PLAYER_LEVEL;
        }

        @Override
        public boolean LevelUp(EntityPlayer player) {
            if (!this.CheckIfCanLevelUp()) {
                player.func_145747_a((ITextComponent)SLOC.chat("not_enough_experience"));
            } else if (!this.CheckLevelCap()) {
                player.func_145747_a((ITextComponent)SLOC.chat("cannot_over_maximum_level"));
            }
            if (this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
                this.setLevel(this.level + 1, (EntityLivingBase)player);
                this.setExp(this.getRemainingExp());
                player.func_145747_a((ITextComponent)SLOC.chat("levelup_success"));
                return true;
            }
            return false;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void setLevel(int lvl, EntityLivingBase entity) {
            if (lvl > ModConfig.Server.MAXIMUM_PLAYER_LEVEL) {
                lvl = ModConfig.Server.MAXIMUM_PLAYER_LEVEL;
            }
            this.level = lvl;
        }

        @Override
        public int getExp() {
            return this.exp;
        }

        @Override
        public void setExp(int exp) {
            this.exp = exp;
        }

        @Override
        public void syncToClient(EntityPlayer player) {
            if (this.unit != null) {
                PlayerUnitPackage packet = new PlayerUnitPackage(this.getNBT());
                Main.Network.sendTo((IMessage)packet, (EntityPlayerMP)player);
            }
        }

        @Override
        public Unit getUnit() {
            return this.unit;
        }

        @Override
        public void setUnit(Unit unit, EntityLivingBase entity) {
            this.unit = unit;
        }

        @Override
        public void setRarity(int rarity) {
            this.rarity = rarity;
        }

        @Override
        public int getRarity() {
            return this.rarity;
        }

        @Override
        public String getUUID() {
            return this.uuid;
        }

        @Override
        public void setUUID(UUID id) {
            this.uuid = id.toString();
        }

        @Override
        public String getName(EntityLivingBase entity) {
            if (entity instanceof EntityPlayer) {
                return TextFormatting.YELLOW + "[Lv:" + this.getLevel() + "]  " + entity.func_145748_c_().func_150254_d();
            }
            MobRarity rarity = Rarities.Mobs.get(this.getRarity());
            String rarityprefix = "";
            String name = "";
            name = entity.func_145748_c_().func_150254_d();
            rarityprefix = rarity.locName();
            return TextFormatting.YELLOW + "[Lv:" + this.getLevel() + "] " + rarity.Color() + rarityprefix + " " + name;
        }

        @Override
        public void HandleCloneEvent(UnitData old) {
            this.setNBT(old.getNBT());
        }

        @Override
        public void recalculateStats(EntityLivingBase entity, WorldData.IWorldData world) {
            this.unit.RecalculateStats(entity, this, this.level, world);
        }

        @Override
        public void forceSetUnit(Unit unit) {
            this.unit = unit;
        }

        @Override
        public boolean tryUseWeapon(EntityLivingBase source, ItemStack weapon) {
            try {
                GearItemData weaponData = Gear.Load(weapon);
                if (weaponData != null && weaponData.GetBaseGearType() instanceof IWeapon) {
                    IWeapon iwep = (IWeapon)((Object)weaponData.GetBaseGearType());
                    float energyCost = iwep.mechanic().GetEnergyCost();
                    if (!this.hasEnoughEnergy(energyCost)) {
                        AttackUtils.NoEnergyMessage((Entity)source);
                        return false;
                    }
                    this.consumeEnergy(energyCost);
                    weapon.func_77972_a(1, source);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public void attackWithWeapon(EntityLivingBase source, EntityLivingBase target, ItemStack weapon) {
            UnitData targetData = Load.Unit((ICapabilityProvider)target);
            GearItemData weaponData = Gear.Load(weapon);
            if (weapon != null && !weapon.func_190926_b() && weaponData.GetBaseGearType() instanceof IWeapon) {
                IWeapon iwep = (IWeapon)((Object)weaponData.GetBaseGearType());
                WeaponMechanic iWep = iwep.mechanic();
                iWep.Attack(source, target, this, targetData);
            }
        }

        @Override
        public void onMobKill(final WorldData.IWorldData world) {
            Runnable noteThread = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (kills == null) {
                            kills = new PlayerMapKillsData();
                        }
                        kills.onKill(world.getMap());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(noteThread);
        }

        @Override
        public int getLootBonusPerAffixKills(MapItemData map) {
            if (this.kills == null) {
                return 0;
            }
            return this.kills.getLootMulti(map);
        }

        @Override
        public void onLogin(EntityPlayer player) {
            try {
                if (this.unit == null) {
                    this.unit = new Unit();
                    this.unit.InitPlayerStats();
                    if (ModConfig.Server.GENERATE_GEAR) {
                        OnLogin.GiveStarterItems(player);
                    }
                } else {
                    this.getUnit().InitPlayerStats();
                    this.recalculateStats((EntityLivingBase)player, Load.World((ICapabilityProvider)player));
                }
                if (this.kills == null) {
                    this.kills = new PlayerMapKillsData();
                }
                this.kills.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public float getCurrentMana() {
            return this.mana;
        }

        @Override
        public float getCurrentEnergy() {
            return this.energy;
        }

        @Override
        public void setCurrentEnergy(float i) {
            this.energy = i;
        }

        @Override
        public void setCurrentMana(float i) {
            this.mana = i;
        }

        @Override
        public boolean hasEnoughMana(float i) {
            return this.mana >= i;
        }

        @Override
        public boolean hasEnoughEnergy(float i) {
            return this.energy >= i;
        }

        @Override
        public void restoreMana(float i) {
            float max = this.unit.manaData().Value;
            this.mana += i;
            if (this.mana > max) {
                this.mana = (int)max;
            }
        }

        @Override
        public void restoreEnergy(float i) {
            float max = this.unit.energyData().Value;
            this.energy += i;
            if (this.energy > max) {
                this.energy = (int)max;
            }
        }

        @Override
        public void consumeMana(float i) {
            this.mana -= i;
            if (this.mana < 0.0f) {
                this.mana = 0.0f;
            }
        }

        @Override
        public void consumeEnergy(float i) {
            this.energy -= i;
            if (this.energy < 0.0f) {
                this.energy = 0.0f;
            }
        }

        @Override
        public void heal(EntityLivingBase entity, int healthrestored) {
            entity.func_70691_i(HealthUtils.DamageToMinecraftHealth((float)healthrestored / ModConfig.Server.NON_MOD_HEAL_MULTI, entity));
        }

        @Override
        public boolean increaseRarity(EntityLivingBase entity) {
            if (this.rarity == 5) {
                return false;
            }
            ++this.rarity;
            return true;
        }

        @Override
        public boolean decreaseRarity(EntityLivingBase entity) {
            if (this.rarity - 1 < 0) {
                return false;
            }
            --this.rarity;
            return true;
        }

        @Override
        public int getCurrentMapId() {
            return this.currentMapId;
        }

        @Override
        public void setCurrentMapId(int id) {
            this.currentMapId = id;
        }

        @Override
        public boolean hasCurrentMapId() {
            return this.currentMapId != 0;
        }

        @Override
        public void clearCurrentMapId() {
            this.currentMapId = 0;
        }

        @Override
        public void unarmedAttack(EntityLivingBase source, EntityLivingBase target) {
            float cost = ModConfig.Server.UNARMED_ENERGY_COST;
            if (this.hasEnoughEnergy(cost)) {
                this.consumeEnergy(cost);
                int num = (int)this.unit.MyStats.get((Object)PhysicalDamage.GUID).Value;
                DamageEffect dmg = new DamageEffect(source, target, num);
                dmg.Activate();
            }
        }

        @Override
        public boolean isWeapon(ItemStack stack) {
            try {
                if (stack == null || stack.func_190926_b()) {
                    return false;
                }
                GearItemData weaponData = Gear.Load(stack);
                if (weaponData != null && weaponData.GetBaseGearType() instanceof IWeapon) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public void freelySetLevel(int lvl) {
            this.level = lvl;
        }

        @Override
        public void onDamagedByNonPlayer(float dmg) {
            this.dmgByNonPlayers += dmg;
        }

        @Override
        public boolean shouldDropLoot(EntityLivingBase entity) {
            return entity.func_110138_aP() * ModConfig.Server.STOP_DROPS_IF_NON_PLAYER_DOES_DMG_PERCENT > this.dmgByNonPlayers;
        }
    }

    public static class Storage
    implements Capability.IStorage<UnitData> {
        public NBTBase writeNBT(Capability<UnitData> capability, UnitData instance, EnumFacing side) {
            return instance.getNBT();
        }

        public void readNBT(Capability<UnitData> capability, UnitData instance, EnumFacing side, NBTBase nbt) {
            instance.setNBT((NBTTagCompound)nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            boolean can = false;
            if (ModConfig.Server.ENTITIES_UNDER_SYSTEM.equals((Object)EntitySystemChoice.All_Entities) && event.getObject() instanceof EntityLivingBase) {
                can = true;
            }
            if (ModConfig.Server.ENTITIES_UNDER_SYSTEM.equals((Object)EntitySystemChoice.Mobs_And_Players) && (event.getObject() instanceof IMob || event.getObject() instanceof EntityPlayer)) {
                can = true;
            }
            if (can) {
                event.addCapability(new ResourceLocation("mmorpg", "EntityData"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                    UnitData inst = new DefaultImpl();

                    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                        return capability == Data;
                    }

                    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                        return (T)(capability == Data ? Data.cast((Object)this.inst) : null);
                    }

                    public NBTTagCompound serializeNBT() {
                        return (NBTTagCompound)Data.getStorage().writeNBT(Data, (Object)this.inst, null);
                    }

                    public void deserializeNBT(NBTTagCompound nbt) {
                        Data.getStorage().readNBT(Data, (Object)this.inst, null, (NBTBase)nbt);
                    }
                });
            }
        }
    }

    public static interface UnitData
    extends ICommonCapability {
        public void onDamagedByNonPlayer(float var1);

        public boolean shouldDropLoot(EntityLivingBase var1);

        public void freelySetLevel(int var1);

        public int getLevel();

        public void setLevel(int var1, EntityLivingBase var2);

        public boolean increaseRarity(EntityLivingBase var1);

        public int getExp();

        public int PostGiveExpEvent(EntityPlayer var1, int var2);

        public void setExp(int var1);

        public int GiveExp(EntityPlayer var1, int var2);

        public int GetExpRequiredForLevelUp();

        public boolean CheckIfCanLevelUp();

        public boolean LevelUp(EntityPlayer var1);

        public boolean CheckLevelCap();

        public void SetMobLevelAtSpawn(WorldData.IWorldData var1, EntityLivingBase var2);

        public Unit getUnit();

        public void setUnit(Unit var1, EntityLivingBase var2);

        public void setRarity(int var1);

        public int getRarity();

        public String getUUID();

        public void setUUID(UUID var1);

        public String getName(EntityLivingBase var1);

        public void HandleCloneEvent(UnitData var1);

        public void recalculateStats(EntityLivingBase var1, WorldData.IWorldData var2);

        public void forceSetUnit(Unit var1);

        public boolean tryUseWeapon(EntityLivingBase var1, ItemStack var2);

        public void attackWithWeapon(EntityLivingBase var1, EntityLivingBase var2, ItemStack var3);

        public void onMobKill(WorldData.IWorldData var1);

        public int getLootBonusPerAffixKills(MapItemData var1);

        public void onLogin(EntityPlayer var1);

        public float getCurrentMana();

        public float getCurrentEnergy();

        public void setCurrentEnergy(float var1);

        public void setCurrentMana(float var1);

        public boolean hasEnoughMana(float var1);

        public boolean hasEnoughEnergy(float var1);

        public void restoreMana(float var1);

        public void restoreEnergy(float var1);

        public void consumeMana(float var1);

        public void consumeEnergy(float var1);

        public void heal(EntityLivingBase var1, int var2);

        public int getCurrentMapId();

        public void setCurrentMapId(int var1);

        public boolean hasCurrentMapId();

        public void clearCurrentMapId();

        public void unarmedAttack(EntityLivingBase var1, EntityLivingBase var2);

        public boolean decreaseRarity(EntityLivingBase var1);

        public boolean isWeapon(ItemStack var1);
    }
}

