/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.capability;

import com.robertx22.saveclasses.DimensionData;
import com.robertx22.saveclasses.MapDataList;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.DimensionType;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MapDatas
extends WorldSavedData {
    public static List<Integer> dimensionIds = new ArrayList<Integer>();
    String LOCATION;
    MapDataList list = new MapDataList();

    public MapDatas(String name) {
        super(name);
        this.LOCATION = MapDatas.getLoc();
        this.func_76186_a(true);
    }

    public static String getLoc() {
        return DimensionManager.getCurrentSaveRootDirectory().getName();
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        if (this.list != null) {
            NBTTagCompound dimnbt = new NBTTagCompound();
            Writer.write(dimnbt, this.list);
            nbt.func_74782_a(this.LOCATION, (NBTBase)dimnbt);
        }
        return nbt;
    }

    public void func_76184_a(NBTTagCompound value) {
        NBTTagCompound dimnbt = (NBTTagCompound)value.func_74781_a(this.LOCATION);
        if (dimnbt != null) {
            Reader.read(dimnbt, this.list);
        }
    }

    public void register(DimensionData data) {
        this.reg(data);
        this.list.dimDatas.put(data.ID, data);
        this.func_76186_a(true);
    }

    public void delete(int id) {
        this.list.dimDatas.remove(id);
        this.func_76186_a(true);
        for (int i = 0; i < dimensionIds.size(); ++i) {
            if (dimensionIds.get(i) != id) continue;
            dimensionIds.remove(i);
            break;
        }
        if (DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.unregisterDimension((int)id);
        }
    }

    private void reg(DimensionData data) {
        DimensionType type = data.getDimensionType();
        dimensionIds.add(data.ID);
        if (type != null) {
            if (!DimensionManager.isDimensionRegistered((int)data.ID)) {
                DimensionManager.registerDimension((int)data.ID, (DimensionType)type);
            }
        } else {
            DimensionManager.unregisterDimension((int)data.ID);
            DimensionManager.registerDimension((int)data.ID, (DimensionType)type);
        }
    }

    private void registerReserved(int id) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.registerDimension((int)id, (DimensionType)DimensionType.OVERWORLD);
            DimensionManager.initDimension((int)id);
            WorldData.IWorldData world = Load.World((ICapabilityProvider)DimensionManager.getWorld((int)id));
            world.setReserved(true);
        }
    }

    public void registerDimensions() {
        dimensionIds.clear();
        for (DimensionData data : this.list.dimDatas.values()) {
            this.reg(data);
            dimensionIds.add(data.ID);
        }
    }

    public static void unregisterDimensions() {
        for (int id : dimensionIds) {
            if (!DimensionManager.isDimensionRegistered((int)id)) continue;
            DimensionManager.unregisterDimension((int)id);
        }
    }
}

