/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.capability;

import com.robertx22.saveclasses.ItemListData;
import com.robertx22.uncommon.capability.bases.ICommonCapability;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PlayerDeathItems {
    @CapabilityInject(value=IPlayerDrops.class)
    public static final Capability<IPlayerDrops> Data = null;
    public static final String ITEM_LIST_OBJ = "items_list";

    public static class DefaultImpl
    implements IPlayerDrops {
        private NBTTagCompound nbt = new NBTTagCompound();
        ItemListData item_list = new ItemListData();

        @Override
        public NBTTagCompound getNBT() {
            if (this.item_list != null) {
                NBTTagCompound itemsnbt = new NBTTagCompound();
                Writer.write(itemsnbt, this.item_list);
                this.nbt.func_74782_a(PlayerDeathItems.ITEM_LIST_OBJ, (NBTBase)itemsnbt);
            }
            return this.nbt;
        }

        @Override
        public void setNBT(NBTTagCompound value) {
            NBTTagCompound object_nbt = (NBTTagCompound)this.nbt.func_74781_a(PlayerDeathItems.ITEM_LIST_OBJ);
            if (object_nbt != null) {
                this.item_list = new ItemListData();
                Reader.read(object_nbt, this.item_list);
            }
        }

        @Override
        public void syncToClient(EntityPlayer player) {
        }

        @Override
        public void saveItems(List<EntityItem> items) {
            for (EntityItem item : items) {
                this.item_list.items.add(item.func_92059_d());
                item.func_92058_a(ItemStack.field_190927_a);
            }
        }

        @Override
        public List<ItemStack> getItems() {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.item_list.items);
            this.item_list.items.clear();
            return items;
        }

        @Override
        public void saveItem(ItemStack stack) {
            this.item_list.items.add(stack);
        }
    }

    public static class Storage
    implements Capability.IStorage<IPlayerDrops> {
        public NBTBase writeNBT(Capability<IPlayerDrops> capability, IPlayerDrops instance, EnumFacing side) {
            return instance.getNBT();
        }

        public void readNBT(Capability<IPlayerDrops> capability, IPlayerDrops instance, EnumFacing side, NBTBase nbt) {
            instance.setNBT((NBTTagCompound)nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(new ResourceLocation("mmorpg", "PlayerDeathItems"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                    IPlayerDrops inst = new DefaultImpl();

                    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                        return capability == Data;
                    }

                    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                        return (T)(capability == Data ? Data.cast((Object)this.inst) : null);
                    }

                    public NBTTagCompound serializeNBT() {
                        return (NBTTagCompound)Data.getStorage().writeNBT(Data, (Object)this.inst, null);
                    }

                    public void deserializeNBT(NBTTagCompound nbt) {
                        Data.getStorage().readNBT(Data, (Object)this.inst, null, (NBTBase)nbt);
                    }
                });
            }
        }
    }

    public static interface IPlayerDrops
    extends ICommonCapability {
        public void saveItems(List<EntityItem> var1);

        public void saveItem(ItemStack var1);

        public List<ItemStack> getItems();
    }
}

