/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.capability;

import com.robertx22.dimensions.MyTeleporter;
import com.robertx22.saveclasses.MapItemData;
import com.robertx22.saveclasses.MapWorldData;
import com.robertx22.uncommon.SLOC;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class WorldData {
    @CapabilityInject(value=IWorldData.class)
    public static final Capability<IWorldData> Data = null;
    static final String SET_FOR_DELETE = "setForDelete";
    static final String IS_MAP_WORLD = "isMap";
    static final String LEVEL = "level";
    static final String OWNER = "owner";
    static final String TIER = "tier";
    static final String MAP_OBJECT = "mapObject";
    static final String IS_INIT = "isInit";
    static final String ORIGINAL_DIM = "original_dimension";
    static final String MAP_DIM = "map_dimension";
    static final String DIDNT_SET_BACK_PORTAL = "didntSetBackPortal";
    static final String SAVE_NAME = "save_name";
    static final String POS_OBJ = "POS_OBJ";
    static final String MAP_WORLD_OBJ = "MAP_WORLD_OBJ";
    static final String MINUTES_PASSED = "minutes_passed";
    static final String ISRESERVED = "is_reserved";

    public static class DefaultImpl
    implements IWorldData {
        private NBTTagCompound nbt = new NBTTagCompound();
        long mapDevicePos;
        MapItemData mapdata = new MapItemData();
        MapWorldData mapworlddata = new MapWorldData();
        int tier = 0;
        int level = 0;
        boolean isMap = false;
        boolean setForDelete = false;
        String owner = "";
        boolean isInit = false;
        int originalDimension;
        int mapDimension;
        boolean didntSetBackPortal = true;
        String saveName = "";
        int minutesPassed;
        boolean reserved = false;

        @Override
        public NBTTagCompound getNBT() {
            NBTTagCompound tag;
            this.nbt.func_74768_a(WorldData.TIER, this.tier);
            this.nbt.func_74768_a(WorldData.LEVEL, this.level);
            this.nbt.func_74757_a(WorldData.IS_MAP_WORLD, this.isMap);
            this.nbt.func_74757_a(WorldData.SET_FOR_DELETE, this.setForDelete);
            this.nbt.func_74778_a(WorldData.OWNER, this.owner);
            this.nbt.func_74757_a(WorldData.IS_INIT, this.isInit);
            this.nbt.func_74768_a(WorldData.ORIGINAL_DIM, this.originalDimension);
            this.nbt.func_74768_a(WorldData.MAP_DIM, this.mapDimension);
            this.nbt.func_74757_a(WorldData.DIDNT_SET_BACK_PORTAL, this.didntSetBackPortal);
            this.nbt.func_74778_a(WorldData.SAVE_NAME, this.saveName);
            this.nbt.func_74768_a(WorldData.MINUTES_PASSED, this.minutesPassed);
            this.nbt.func_74757_a(WorldData.ISRESERVED, this.reserved);
            if (this.mapdata != null) {
                tag = new NBTTagCompound();
                Writer.write(tag, this.mapdata);
                this.nbt.func_74782_a(WorldData.MAP_OBJECT, (NBTBase)tag);
            }
            if (this.mapworlddata != null) {
                tag = new NBTTagCompound();
                Writer.write(tag, this.mapworlddata);
                this.nbt.func_74782_a(WorldData.MAP_WORLD_OBJ, (NBTBase)tag);
            }
            this.nbt.func_74772_a(WorldData.POS_OBJ, this.mapDevicePos);
            return this.nbt;
        }

        @Override
        public void setNBT(NBTTagCompound value) {
            NBTTagCompound mapworldnbt;
            this.nbt = value;
            this.tier = this.nbt.func_74762_e(WorldData.TIER);
            this.level = this.nbt.func_74762_e(WorldData.LEVEL);
            this.isMap = this.nbt.func_74767_n(WorldData.IS_MAP_WORLD);
            this.setForDelete = this.nbt.func_74767_n(WorldData.SET_FOR_DELETE);
            this.owner = this.nbt.func_74779_i(WorldData.OWNER);
            this.isInit = this.nbt.func_74767_n(WorldData.IS_INIT);
            this.originalDimension = this.nbt.func_74762_e(WorldData.ORIGINAL_DIM);
            this.mapDimension = this.nbt.func_74762_e(WorldData.MAP_DIM);
            this.didntSetBackPortal = this.nbt.func_74767_n(WorldData.DIDNT_SET_BACK_PORTAL);
            this.saveName = this.nbt.func_74779_i(WorldData.SAVE_NAME);
            this.minutesPassed = this.nbt.func_74762_e(WorldData.MINUTES_PASSED);
            this.reserved = this.nbt.func_74767_n(WorldData.ISRESERVED);
            NBTTagCompound mapnbt = (NBTTagCompound)this.nbt.func_74781_a(WorldData.MAP_OBJECT);
            if (mapnbt != null) {
                Reader.read(mapnbt, this.mapdata);
            }
            if ((mapworldnbt = (NBTTagCompound)this.nbt.func_74781_a(WorldData.MAP_WORLD_OBJ)) != null) {
                Reader.read(mapworldnbt, this.mapworlddata);
            }
            this.mapDevicePos = this.nbt.func_74763_f(WorldData.POS_OBJ);
        }

        @Override
        public boolean isMapWorld() {
            return this.isMap;
        }

        @Override
        public boolean isSetForDelete() {
            return this.setForDelete;
        }

        @Override
        public int getWorldID() {
            return this.mapDimension;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void setOwner(EntityPlayer player) {
            this.owner = player.func_110124_au().toString();
        }

        @Override
        public String getOwner() {
            return this.owner;
        }

        @Override
        public void delete(EntityPlayer player, World mapworld) {
            if (this.isMapWorld()) {
                if (this.isOwner(player)) {
                    this.setForDelete = true;
                    this.transferPlayersBack(mapworld);
                } else {
                    player.func_145747_a((ITextComponent)SLOC.chat("cant_delete_world"));
                }
            }
        }

        @Override
        public void init(BlockPos pos, World world, MapItemData map, int dimensionId, EntityPlayer owner) {
            this.isMap = true;
            this.level = map.level;
            this.tier = map.tier;
            this.mapdata = map;
            this.originalDimension = world.field_73011_w.getDimension();
            this.mapDimension = dimensionId;
            this.mapDevicePos = pos.func_177986_g();
            this.isInit = true;
            this.setOwner(owner);
            this.reserved = false;
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public MapItemData getMap() {
            return this.mapdata;
        }

        @Override
        public boolean isInit() {
            return this.isInit;
        }

        @Override
        public boolean didntSetBackPortal() {
            return this.didntSetBackPortal;
        }

        @Override
        public void setBackPortal() {
            this.didntSetBackPortal = false;
        }

        @Override
        public String getSaveName() {
            return this.saveName;
        }

        @Override
        public void setSaveName(String name) {
            this.saveName = name;
        }

        @Override
        public BlockPos getMapDevicePos() {
            return BlockPos.func_177969_a((long)this.mapDevicePos).func_177970_e(3);
        }

        @Override
        public int getOriginalDimension() {
            return this.originalDimension;
        }

        private void transferPlayersBack(World world) {
            if (world.field_73010_i != null) {
                ArrayList players = new ArrayList(world.field_73010_i);
                for (EntityPlayer player : players) {
                    if (!player.func_70089_S()) continue;
                    this.teleportPlayerBack(player);
                }
            }
        }

        @Override
        public void teleportPlayerBack(EntityPlayer player) {
            BlockPos pos = player.func_180470_cg();
            if (this.getMapDevicePos() != null) {
                pos = this.getMapDevicePos();
                if ((pos = pos.func_177964_d(2)) != null) {
                    player.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                }
            }
            player.changeDimension(this.originalDimension, (ITeleporter)new MyTeleporter(player.field_70170_p, pos, player));
        }

        @Override
        public MapWorldData getWorldData() {
            return this.mapworlddata;
        }

        @Override
        public void setWorldData(MapWorldData data) {
            this.mapworlddata = data;
        }

        @Override
        public void passMinute(World world) {
            if (this.isMap) {
                ++this.minutesPassed;
                this.onMinutePassAnnounce(world);
                this.checkDeletition(world);
            }
        }

        private void onMinutePassAnnounce(World world) {
            int minutesLeft = this.getMinutesLeft();
            if (minutesLeft > 0 && (minutesLeft < 5 || minutesLeft % 5 == 0)) {
                this.announceTimeLeft(world);
            }
        }

        private void checkDeletition(World world) {
            if (this.getMinutesLeft() < 1) {
                this.setDelete(true, world);
            }
        }

        private int getMinutesLeft() {
            return this.mapdata.minutes - this.minutesPassed;
        }

        private void announceDeletition(World world) {
            for (EntityPlayer player : world.field_73010_i) {
                player.func_145747_a((ITextComponent)SLOC.chat("mapworld_ran_out_of_time"));
            }
        }

        private void announceTimeLeft(World world) {
            for (EntityPlayer player : world.field_73010_i) {
                player.func_145747_a(SLOC.chat("mapworld_time_left").func_150258_a(" " + this.getMinutesLeft() + " ").func_150257_a((ITextComponent)SLOC.chat("minutes")));
            }
        }

        @Override
        public void setDelete(boolean bool, World world) {
            this.setForDelete = bool;
            if (bool) {
                this.announceDeletition(world);
                this.transferPlayersBack(world);
            }
        }

        @Override
        public void onPlayerDeath(EntityPlayer victim, World world) {
            int punishment = 5;
            for (EntityPlayer player : world.field_73010_i) {
                player.func_145747_a(SLOC.chat("player_died_mapworld").func_150258_a(" " + victim.func_145748_c_().func_150254_d() + " ").func_150257_a((ITextComponent)SLOC.chat("activating_mapworld_time_penalty")));
            }
            this.minutesPassed += punishment;
            this.announceTimeLeft(world);
            this.checkDeletition(world);
        }

        @Override
        public boolean isReserved() {
            return this.reserved;
        }

        @Override
        public void setReserved(boolean bool) {
            this.reserved = bool;
        }

        @Override
        public boolean isOwner(EntityPlayer player) {
            return player.func_110124_au().toString().equals(this.owner);
        }
    }

    public static class Storage
    implements Capability.IStorage<IWorldData> {
        public NBTBase writeNBT(Capability<IWorldData> capability, IWorldData instance, EnumFacing side) {
            return instance.getNBT();
        }

        public void readNBT(Capability<IWorldData> capability, IWorldData instance, EnumFacing side, NBTBase nbt) {
            instance.setNBT((NBTTagCompound)nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onWorldConstuct(AttachCapabilitiesEvent<World> event) {
            event.addCapability(new ResourceLocation("mmorpg", "WorldData"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IWorldData inst = new DefaultImpl();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == Data;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == Data ? Data.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)Data.getStorage().writeNBT(Data, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    Data.getStorage().readNBT(Data, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
        }
    }

    public static interface IWorldData {
        public NBTTagCompound getNBT();

        public void setNBT(NBTTagCompound var1);

        public boolean isMapWorld();

        public boolean isSetForDelete();

        public int getWorldID();

        public int getTier();

        public int getLevel();

        public void setOwner(EntityPlayer var1);

        public String getOwner();

        public void init(BlockPos var1, World var2, MapItemData var3, int var4, EntityPlayer var5);

        public void delete(EntityPlayer var1, World var2);

        public MapItemData getMap();

        public boolean isInit();

        public boolean didntSetBackPortal();

        public void setBackPortal();

        public String getSaveName();

        public void setSaveName(String var1);

        public BlockPos getMapDevicePos();

        public int getOriginalDimension();

        public void teleportPlayerBack(EntityPlayer var1);

        public MapWorldData getWorldData();

        public void setWorldData(MapWorldData var1);

        public void passMinute(World var1);

        public void onPlayerDeath(EntityPlayer var1, World var2);

        public void setDelete(boolean var1, World var2);

        public boolean isReserved();

        public void setReserved(boolean var1);

        public boolean isOwner(EntityPlayer var1);
    }
}

