/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.capability.bases;

import com.robertx22.database.rarities.MobRarity;
import com.robertx22.database.stat_types.defense.Armor;
import com.robertx22.database.stat_types.elementals.resist.FireResist;
import com.robertx22.database.stat_types.elementals.resist.NatureResist;
import com.robertx22.database.stat_types.elementals.resist.ThunderResist;
import com.robertx22.database.stat_types.elementals.resist.WaterResist;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellFireDamage;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellNatureDamage;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellThunderDamage;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellWaterDamage;
import com.robertx22.database.stat_types.offense.CriticalDamage;
import com.robertx22.database.stat_types.offense.CriticalHit;
import com.robertx22.database.status.effects.bases.BaseStatusEffect;
import com.robertx22.db_lists.Rarities;
import com.robertx22.db_lists.StatusEffects;
import com.robertx22.saveclasses.StatData;
import com.robertx22.saveclasses.Unit;
import com.robertx22.saveclasses.effects.StatusEffectData;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.utilityclasses.ListUtils;
import com.robertx22.uncommon.utilityclasses.RandomUtils;
import net.minecraft.entity.EntityLivingBase;

public class MobStatUtils {
    static int spelldmg = 8;
    static int spellresist = 4;

    public static void AddMobcStats(EntityData.UnitData unitdata, int level) {
        MobRarity rar = Rarities.Mobs.get(unitdata.getRarity());
        Unit unit = unitdata.getUnit();
        unit.MyStats.get((Object)Armor.GUID).Flat += (float)(10 * level) * rar.StatMultiplier();
        unit.MyStats.get((Object)CriticalHit.GUID).Flat += 5.0f * rar.StatMultiplier();
        unit.MyStats.get((Object)CriticalDamage.GUID).Flat += 5.0f * rar.StatMultiplier();
        unit.MyStats.get((Object)WaterResist.GUID).Flat += (float)(spellresist * level) * rar.StatMultiplier();
        unit.MyStats.get((Object)FireResist.GUID).Flat += (float)(spellresist * level) * rar.StatMultiplier();
        unit.MyStats.get((Object)ThunderResist.GUID).Flat += (float)(spellresist * level) * rar.StatMultiplier();
        unit.MyStats.get((Object)NatureResist.GUID).Flat += (float)(spellresist * level) * rar.StatMultiplier();
        unit.MyStats.get((Object)SpellWaterDamage.GUID).Flat += (float)(spelldmg * level) * rar.DamageMultiplier();
        unit.MyStats.get((Object)SpellFireDamage.GUID).Flat += (float)(spelldmg * level) * rar.DamageMultiplier();
        unit.MyStats.get((Object)SpellThunderDamage.GUID).Flat += (float)(spelldmg * level) * rar.DamageMultiplier();
        unit.MyStats.get((Object)SpellNatureDamage.GUID).Flat += (float)(spelldmg * level) * rar.DamageMultiplier();
    }

    public static void AddMobTierStats(Unit unit, int tier) {
        for (StatData data : unit.MyStats.values()) {
            float newval;
            if (data.GetStat().IsPercent()) continue;
            unit.MyStats.get((Object)data.Name).Flat = newval = MobStatUtils.IncByPercent(data.Flat, tier);
        }
    }

    private static float IncByPercent(float val, int tier) {
        return val + val * (float)tier * 10.0f / 100.0f;
    }

    public static void AddRandomMobStatusEffects(EntityLivingBase entity, Unit unit, MobRarity rarity) {
        int max = rarity.MaxMobEffects();
        if (max > 0) {
            if (max > StatusEffects.All.values().size()) {
                System.out.println("ERROR! Can't have more unique effects than there are effects!");
                max = StatusEffects.All.values().size() - 1;
            }
            for (int amount = RandomUtils.RandomRange(0, max); amount > 0; --amount) {
                BaseStatusEffect effect = null;
                while (effect == null || unit.statusEffects.containsKey(effect.GUID())) {
                    effect = (BaseStatusEffect)RandomUtils.WeightedRandom(ListUtils.CollectionToList(StatusEffects.All.values()));
                }
                unit.statusEffects.put(effect.GUID(), new StatusEffectData(effect));
            }
        }
    }
}

