/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.capability.bases;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.robertx22.config.ModConfig;
import com.robertx22.database.stats.IStatConversion;
import com.robertx22.database.stats.IStatTransfer;
import com.robertx22.database.stats.Stat;
import com.robertx22.database.stats.StatMod;
import com.robertx22.database.stats.Trait;
import com.robertx22.db_lists.Sets;
import com.robertx22.saveclasses.GearItemData;
import com.robertx22.saveclasses.StatData;
import com.robertx22.saveclasses.Unit;
import com.robertx22.saveclasses.gearitem.StatModData;
import com.robertx22.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.saveclasses.gearitem.gear_bases.Set;
import com.robertx22.uncommon.SLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.datasaving.Gear;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class PlayerStatUtils {
    public static void AddPlayerBaseStats(EntityData.UnitData data, Unit unit) {
        unit.MyStats.get((Object)"Thunder Resist").Flat += (float)((int)(ModConfig.BasePlayerStats.thunder_resist + (float)data.getLevel() * ModConfig.BasePlayerStats.thunder_resist_per_level));
        unit.MyStats.get((Object)"Water Penetration").Flat += (float)((int)(ModConfig.BasePlayerStats.water_penetration + (float)data.getLevel() * ModConfig.BasePlayerStats.water_penetration_per_level));
        unit.MyStats.get((Object)"Physical Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.physical_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.physical_damage_per_level));
        unit.MyStats.get((Object)"Mana").Flat += (float)((int)(ModConfig.BasePlayerStats.mana + (float)data.getLevel() * ModConfig.BasePlayerStats.mana_per_level));
        unit.MyStats.get((Object)"Dodge").Flat += (float)((int)(ModConfig.BasePlayerStats.dodge + (float)data.getLevel() * ModConfig.BasePlayerStats.dodge_per_level));
        unit.MyStats.get((Object)"Energy").Flat += (float)((int)(ModConfig.BasePlayerStats.energy + (float)data.getLevel() * ModConfig.BasePlayerStats.energy_per_level));
        unit.MyStats.get((Object)"Spell Fire Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.spell_fire_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.spell_fire_damage_per_level));
        unit.MyStats.get((Object)"Water Resist").Flat += (float)((int)(ModConfig.BasePlayerStats.water_resist + (float)data.getLevel() * ModConfig.BasePlayerStats.water_resist_per_level));
        unit.MyStats.get((Object)"Hammer Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.hammer_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.hammer_damage_per_level));
        unit.MyStats.get((Object)"Fire Resist").Flat += (float)((int)(ModConfig.BasePlayerStats.fire_resist + (float)data.getLevel() * ModConfig.BasePlayerStats.fire_resist_per_level));
        unit.MyStats.get((Object)"Bow Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.bow_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.bow_damage_per_level));
        unit.MyStats.get((Object)"Spell Water Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.spell_water_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.spell_water_damage_per_level));
        unit.MyStats.get((Object)"Spell Dodge").Flat += (float)((int)(ModConfig.BasePlayerStats.spell_dodge + (float)data.getLevel() * ModConfig.BasePlayerStats.spell_dodge_per_level));
        unit.MyStats.get((Object)"All Water Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.all_water_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.all_water_damage_per_level));
        unit.MyStats.get((Object)"All Fire Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.All_Fire_Damage + (float)data.getLevel() * ModConfig.BasePlayerStats.All_Fire_Damage_per_level));
        unit.MyStats.get((Object)"Mana Regen").Flat += (float)((int)(ModConfig.BasePlayerStats.mana_regen + (float)data.getLevel() * ModConfig.BasePlayerStats.mana_regen_per_level));
        unit.MyStats.get((Object)"Spell Thunder Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.spell_thunder_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.spell_thunder_damage_per_level));
        unit.MyStats.get((Object)"Life On Hit").Flat += (float)((int)(ModConfig.BasePlayerStats.life_on_hit + (float)data.getLevel() * ModConfig.BasePlayerStats.life_on_hit_per_level));
        unit.MyStats.get((Object)"Staff Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.staff_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.staff_damage_per_level));
        unit.MyStats.get((Object)"Thunder Penetration").Flat += (float)((int)(ModConfig.BasePlayerStats.thunder_penetration + (float)data.getLevel() * ModConfig.BasePlayerStats.thunder_penetration_per_level));
        unit.MyStats.get((Object)"All Thunder Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.all_thunder_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.all_thunder_damage_per_level));
        unit.MyStats.get((Object)"Mana On Hit").Flat += (float)((int)(ModConfig.BasePlayerStats.mana_on_hit + (float)data.getLevel() * ModConfig.BasePlayerStats.mana_on_hit_per_level));
        unit.MyStats.get((Object)"Attack Thunder Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.attack_thunder_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.attack_thunder_damage_per_level));
        unit.MyStats.get((Object)"Nature Penetration").Flat += (float)((int)(ModConfig.BasePlayerStats.nature_penetration + (float)data.getLevel() * ModConfig.BasePlayerStats.nature_penetration_per_level));
        unit.MyStats.get((Object)"All Nature Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.all_nature_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.all_nature_damage_per_level));
        unit.MyStats.get((Object)"Attack Fire Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.attack_fire_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.attack_fire_damage_per_level));
        unit.MyStats.get((Object)"Nature Resist").Flat += (float)((int)(ModConfig.BasePlayerStats.nature_resist + (float)data.getLevel() * ModConfig.BasePlayerStats.nature_resist_per_level));
        unit.MyStats.get((Object)"Sword Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.sword_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.sword_damage_per_level));
        unit.MyStats.get((Object)"Health Regen").Flat += (float)((int)(ModConfig.BasePlayerStats.health_regen + (float)data.getLevel() * ModConfig.BasePlayerStats.health_regen_per_level));
        unit.MyStats.get((Object)"Fire Penetration").Flat += (float)((int)(ModConfig.BasePlayerStats.fire_penetration + (float)data.getLevel() * ModConfig.BasePlayerStats.fire_penetration_per_level));
        unit.MyStats.get((Object)"Armor").Flat += (float)((int)(ModConfig.BasePlayerStats.armor + (float)data.getLevel() * ModConfig.BasePlayerStats.armor_per_level));
        unit.MyStats.get((Object)"Attack Nature Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.attack_nature_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.attack_nature_damage_per_level));
        unit.MyStats.get((Object)"Health").Flat += (float)((int)(ModConfig.BasePlayerStats.health + (float)data.getLevel() * ModConfig.BasePlayerStats.health_per_level));
        unit.MyStats.get((Object)"Attack Water Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.attack_water_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.attack_water_damage_per_level));
        unit.MyStats.get((Object)"Axe Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.axe_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.axe_damage_per_level));
        unit.MyStats.get((Object)"Critical Hit").Flat += (float)((int)(ModConfig.BasePlayerStats.critical_hit + (float)data.getLevel() * ModConfig.BasePlayerStats.critical_hit_per_level));
        unit.MyStats.get((Object)"Spell Nature Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.spell_nature_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.spell_nature_damage_per_level));
        unit.MyStats.get((Object)"Energy Regen").Flat += (float)((int)(ModConfig.BasePlayerStats.energy_regen + (float)data.getLevel() * ModConfig.BasePlayerStats.energy_regen_per_level));
        unit.MyStats.get((Object)"Armor Penetration").Flat += (float)((int)(ModConfig.BasePlayerStats.armor_penetration + (float)data.getLevel() * ModConfig.BasePlayerStats.armor_penetration_per_level));
        unit.MyStats.get((Object)"Critical Damage").Flat += (float)((int)(ModConfig.BasePlayerStats.critical_damage + (float)data.getLevel() * ModConfig.BasePlayerStats.critical_damage_per_level));
        unit.MyStats.get((Object)"Lifesteal").Flat += (float)((int)(ModConfig.BasePlayerStats.lifesteal + (float)data.getLevel() * ModConfig.BasePlayerStats.lifesteal_per_level));
    }

    public static void CalcTraits(EntityData.UnitData unit) {
        for (StatData statdata : unit.getUnit().MyStats.values()) {
            Stat stat = statdata.GetStat();
            if (!(statdata.Value > 0.0f) || !(stat instanceof Trait)) continue;
            Trait affects = (Trait)stat;
            affects.TryAffectOtherStats(unit);
        }
    }

    public static void CalcStatConversionsAndTransfers(Unit copy, Unit unit) {
        for (StatData statdata : copy.MyStats.values()) {
            Object affects;
            Stat stat = statdata.GetStat();
            if (!(statdata.Value > 0.0f)) continue;
            if (stat instanceof IStatConversion) {
                affects = (IStatConversion)((Object)stat);
                affects.convertStats(copy, unit, statdata);
            }
            if (!(stat instanceof IStatTransfer)) continue;
            affects = (IStatTransfer)((Object)stat);
            affects.transferStats(copy, unit, statdata);
        }
    }

    public static List<GearItemData> getEquipsExcludingWeapon(EntityLivingBase entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack == null) continue;
            list.add(stack);
        }
        if (entity instanceof EntityPlayer) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity));
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                if (stack == null) continue;
                list.add(stack);
            }
        }
        ArrayList<GearItemData> gearitems = new ArrayList<GearItemData>();
        for (ItemStack stack : list) {
            GearItemData gear = Gear.Load(stack);
            if (gear == null) continue;
            gearitems.add(gear);
        }
        return gearitems;
    }

    public static void CountWornSets(Entity entity, List<GearItemData> gears, Unit unit) {
        unit.WornSets = new HashMap();
        for (GearItemData gear : gears) {
            if (gear.set == null) continue;
            String set = gear.set.baseSet;
            if (gear.set == null) continue;
            if (unit.WornSets.containsKey(set)) {
                unit.WornSets.put(set, unit.WornSets.get(set) + 1);
                continue;
            }
            unit.WornSets.put(set, 1);
        }
    }

    public static void AddAllSetStats(Entity entity, Unit unit, int level) {
        for (Map.Entry<String, Integer> entry : unit.WornSets.entrySet()) {
            Set set = Sets.All.get(entry.getKey());
            for (StatMod mod : set.GetObtainedMods(unit)) {
                StatModData data = StatModData.Load(mod, set.StatPercent);
                String name = mod.GetBaseStat().Guid();
                if (!unit.MyStats.containsKey(name)) continue;
                unit.MyStats.get(name).Add(data, level);
            }
        }
    }

    public static void AddAllGearStats(Entity entity, List<GearItemData> gears, Unit unit, int level) {
        for (GearItemData gear : gears) {
            if (gear.level > level) {
                if (!(entity instanceof EntityPlayer)) continue;
                entity.func_145747_a((ITextComponent)SLOC.chat("too_high_level"));
                continue;
            }
            List<IStatsContainer.LevelAndStats> levelstats = gear.GetAllStats(gear.level);
            for (IStatsContainer.LevelAndStats datas : levelstats) {
                for (StatModData data : datas.mods) {
                    StatData stat = unit.MyStats.get(data.GetBaseMod().GetBaseStat().Guid());
                    if (stat == null) {
                        System.out.println("Error! can't load a stat called: " + data.GetBaseMod().GetBaseStat().Guid());
                        continue;
                    }
                    stat.Add(data, datas.level);
                }
            }
        }
    }
}

