/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.effectdatas;

import com.robertx22.api.MineAndSlashEvents;
import com.robertx22.config.ModConfig;
import com.robertx22.database.stat_types.defense.BlockStrength;
import com.robertx22.mmorpg.Main;
import com.robertx22.network.DamageNumberPackage;
import com.robertx22.saveclasses.Unit;
import com.robertx22.spells.bases.MyDamageSource;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.effectdatas.EffectData;
import com.robertx22.uncommon.effectdatas.interfaces.IArmorReducable;
import com.robertx22.uncommon.effectdatas.interfaces.ICrittable;
import com.robertx22.uncommon.effectdatas.interfaces.IDamageEffect;
import com.robertx22.uncommon.effectdatas.interfaces.IElementalPenetrable;
import com.robertx22.uncommon.effectdatas.interfaces.IElementalResistable;
import com.robertx22.uncommon.effectdatas.interfaces.IPenetrable;
import com.robertx22.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.uncommon.enumclasses.Elements;
import com.robertx22.uncommon.utilityclasses.HealthUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DamageEffect
extends EffectData
implements IArmorReducable,
IPenetrable,
IDamageEffect,
IElementalResistable,
IElementalPenetrable,
ICrittable {
    public HashMap<Elements, Integer> BonusElementDamageMap = new HashMap();
    public static String DmgSourceName = "mmorpg.custom_damage";
    public Elements Element = Elements.None;
    public int ArmorPene;
    public int ElementalPene;
    public float healthHealed;
    public float manaRestored;
    public boolean crit = false;

    public DamageEffect(EntityLivingBase source, EntityLivingBase target, int dmg) {
        super(source, target);
        this.Number = dmg;
    }

    public DamageEffect(EntityLivingBase source, EntityLivingBase target, int dmg, EntityData.UnitData sourceData, EntityData.UnitData targetData, EffectData.EffectTypes effectType, WeaponTypes weptype) {
        super(source, target, sourceData, targetData);
        this.setEffectType(effectType, weptype);
        this.Number = dmg;
    }

    private boolean canBlockDamageSource(EntityLivingBase target, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && target.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = target.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void activate() {
        boolean fullyblocked = false;
        MyDamageSource dmgsource = new MyDamageSource(DmgSourceName, (Entity)this.Source, this.Element, (int)this.Number);
        float dmg = HealthUtils.DamageToMinecraftHealth(this.Number + 1.0f, this.Target);
        if (this.canBlockDamageSource(this.Target, (DamageSource)dmgsource)) {
            float blockval = this.targetUnit.MyStats.get((Object)BlockStrength.GUID).Value;
            float afterblock = this.Number - blockval;
            if (afterblock < 0.0f) {
                fullyblocked = true;
            } else {
                dmgsource = new MyDamageSource(DmgSourceName, (Entity)this.Source, this.Element, (int)afterblock);
            }
            dmgsource.func_76348_h();
        }
        if (!fullyblocked) {
            this.Target.field_70172_ad = 0;
            this.Target.func_70097_a((DamageSource)dmgsource, dmg);
            this.addBonusElementDamage();
            this.Heal();
            this.RestoreMana();
            if (ModConfig.Client.RENDER_CHAT_COMBAT_LOG) {
                this.LogCombat();
            }
            if ((int)this.Number > 0 && this.Source instanceof EntityPlayerMP) {
                Main.Network.sendTo((IMessage)new DamageNumberPackage(this.Target, this.Element, DamageEffect.FormatDamageNumber(this)), (EntityPlayerMP)this.Source);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.DamageEvent(this.Source, this.Target, this.Number, dmgsource, fullyblocked));
    }

    private void RestoreMana() {
        int restored = (int)this.manaRestored;
        if (restored > 0) {
            this.sourceData.restoreMana(restored);
        }
    }

    private void Heal() {
        int healed = (int)this.healthHealed;
        if (healed > 0) {
            this.sourceData.heal(this.Source, healed);
        }
    }

    private void addBonusElementDamage() {
        for (Map.Entry<Elements, Integer> entry : this.BonusElementDamageMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            DamageEffect bonus = new DamageEffect(this.Source, this.Target, entry.getValue());
            bonus.setEffectType(EffectData.EffectTypes.BONUS_ATTACK, this.weaponType);
            bonus.Element = entry.getKey();
            bonus.Activate();
        }
    }

    private void LogCombat() {
        String s;
        if (this.getEffectType().equals((Object)EffectData.EffectTypes.BONUS_ATTACK)) {
            return;
        }
        if (this.Source instanceof EntityPlayer) {
            s = CLOC.word("dealt") + this.LogDamage() + CLOC.word("to") + " " + this.Target.func_70005_c_() + " " + this.LogCurrentHP(this.Target, this.targetUnit);
            this.Source.func_145747_a((ITextComponent)new TextComponentString(s));
        }
        if (this.Target instanceof EntityPlayer) {
            s = CLOC.word("took") + this.LogDamage() + CLOC.word("from") + " " + this.Source.func_70005_c_() + " " + this.LogCurrentHP(this.Target, this.targetUnit);
            this.Target.func_145747_a((ITextComponent)new TextComponentString(s));
        }
    }

    private String LogCurrentHP(EntityLivingBase entity, Unit unit) {
        String str = TextFormatting.LIGHT_PURPLE + "[" + unit.health().CurrentValue(entity, unit) + "/" + (int)unit.healthData().Value + "]";
        return str;
    }

    public static String FormatNumber(int Number2) {
        String num = "";
        if (Number2 > 10000000) {
            int tenmillions = Number2 / 10000000;
            int leftover = (Number2 - tenmillions * 10000000) / 1000000;
            num = tenmillions + "." + leftover + "k";
        } else {
            num = Number2 + "";
        }
        return num;
    }

    public static String FormatDamageNumber(DamageEffect data) {
        String num = DamageEffect.FormatNumber((int)data.Number);
        if (data.crit) {
            num = num + "!";
        }
        return num;
    }

    private String LogDamage() {
        String num = DamageEffect.FormatDamageNumber(this);
        String str = " " + num + " " + CLOC.word("damage") + " ";
        if (this.Element == null || this.Element.equals((Object)Elements.None)) {
            str = TextFormatting.GRAY + str;
        } else {
            if (this.Element.equals((Object)Elements.Fire)) {
                str = TextFormatting.RED + str;
            }
            if (this.Element.equals((Object)Elements.Water)) {
                str = TextFormatting.BLUE + str;
            }
            if (this.Element.equals((Object)Elements.Thunder)) {
                str = TextFormatting.YELLOW + str;
            }
            if (this.Element.equals((Object)Elements.Nature)) {
                str = TextFormatting.GREEN + str;
            }
        }
        return str;
    }

    @Override
    public EntityLivingBase Source() {
        return this.Source;
    }

    @Override
    public EntityLivingBase Target() {
        return this.Target;
    }

    @Override
    public float Number() {
        return this.Number;
    }

    @Override
    public Elements GetElement() {
        return this.Element;
    }

    @Override
    public void SetArmorPenetration(int val) {
        this.ArmorPene = val;
    }

    @Override
    public void SetElementalPenetration(int val) {
        this.ElementalPene = val;
    }

    @Override
    public int GetArmorPenetration() {
        return this.ArmorPene;
    }

    @Override
    public void SetCrit(boolean bool) {
        this.crit = bool;
    }

    @Override
    public boolean GetCrit() {
        return this.crit;
    }

    @Override
    public int GetElementalPenetration() {
        return this.ElementalPene;
    }
}

