/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.effectdatas;

import com.robertx22.database.stats.IStatEffect;
import com.robertx22.database.stats.IStatEffects;
import com.robertx22.saveclasses.StatData;
import com.robertx22.saveclasses.Unit;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.effectdatas.EffectUnitStat;
import com.robertx22.uncommon.effectdatas.interfaces.WeaponTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class EffectData {
    private EffectTypes effectType = EffectTypes.BASIC_ATTACK;
    public WeaponTypes weaponType = WeaponTypes.None;
    public EntityData.UnitData sourceData;
    public EntityData.UnitData targetData;
    public boolean canceled = false;
    public Unit sourceUnit;
    public Unit targetUnit;
    public EntityLivingBase Source;
    public EntityLivingBase Target;
    public float Number = 0.0f;

    public EffectData(EntityLivingBase source, EntityLivingBase target) {
        this.Source = source;
        this.Target = target;
        if (target != null) {
            this.targetData = Load.Unit((ICapabilityProvider)target);
        }
        if (source != null) {
            this.sourceData = Load.Unit((ICapabilityProvider)source);
        }
        if (source != null) {
            WorldData.IWorldData world = Load.World((ICapabilityProvider)source.field_70170_p);
            try {
                if (target != null) {
                    this.targetUnit = this.targetData.getUnit();
                }
                this.sourceUnit = this.sourceData.getUnit();
                if (this.sourceUnit != null) {
                    this.sourceData.recalculateStats(source, world);
                } else if (this.targetUnit != null) {
                    this.targetData.recalculateStats(target, world);
                } else {
                    this.canceled = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public EffectData(EntityLivingBase source, EntityLivingBase target, EntityData.UnitData sourceData, EntityData.UnitData targetData) {
        this.Source = source;
        this.Target = target;
        if (sourceData != null && targetData != null) {
            this.sourceData = sourceData;
            this.targetData = targetData;
            this.sourceUnit = sourceData.getUnit();
            this.targetUnit = targetData.getUnit();
        } else {
            this.canceled = true;
        }
    }

    public EffectTypes getEffectType() {
        return this.effectType;
    }

    public void setEffectType(EffectTypes effectType, WeaponTypes weaponType) {
        this.effectType = effectType;
        this.weaponType = weaponType;
    }

    public Unit GetSource() {
        return this.sourceUnit;
    }

    public Unit GetTarget() {
        return this.targetUnit;
    }

    public void Activate() {
        if (this.Source == null || this.Target == null || this.canceled || this.sourceUnit == null || this.targetUnit == null || this.sourceData == null || this.targetData == null) {
            return;
        }
        this.TryApplyEffects(this.GetSource());
        this.TryApplyEffects(this.GetTarget());
        if (!this.canceled) {
            this.sourceData.setUnit(this.sourceUnit, this.Source);
            this.targetData.setUnit(this.targetUnit, this.Target);
            this.activate();
        }
    }

    protected abstract void activate();

    protected EffectData TryApplyEffects(Unit unit) {
        if (this.canceled) {
            return this;
        }
        EffectData Data = this;
        List<EffectUnitStat> Effects = new ArrayList<EffectUnitStat>();
        Effects = this.AddEffects(Effects, unit);
        Effects.sort(new EffectUnitStat());
        for (EffectUnitStat item : Effects) {
            if (item.stat.Value == 0.0f || !this.AffectsThisUnit(item.effect, Data, item.source)) continue;
            item.effect.TryModifyEffect(Data, item.source, item.stat, item.stat.GetStat());
        }
        return Data;
    }

    public boolean AffectsThisUnit(IStatEffect effect, EffectData data, Unit source) {
        if (effect.Side().equals((Object)IStatEffect.EffectSides.Target)) {
            return source.equals(data.targetUnit);
        }
        return source.equals(data.sourceUnit);
    }

    private List<EffectUnitStat> AddEffects(List<EffectUnitStat> effects, Unit unit) {
        if (unit != null) {
            for (StatData stat : unit.MyStats.values()) {
                if (!(stat.GetStat() instanceof IStatEffects)) continue;
                for (IStatEffect effect : ((IStatEffects)((Object)stat.GetStat())).GetEffects()) {
                    effects.add(new EffectUnitStat(effect, unit, stat));
                }
            }
        }
        return effects;
    }

    public static enum EffectTypes {
        NORMAL,
        SPELL,
        BASIC_ATTACK,
        BONUS_ATTACK;

    }
}

