/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.effectdatas;

import com.robertx22.database.stats.IStatEffect;
import com.robertx22.database.stats.IStatEffects;
import com.robertx22.saveclasses.StatData;
import com.robertx22.saveclasses.Unit;
import com.robertx22.spells.bases.BaseSpell;
import com.robertx22.uncommon.capability.WorldData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.effectdatas.EffectData;
import com.robertx22.uncommon.effectdatas.EffectUnitStat;
import com.robertx22.uncommon.effectdatas.interfaces.IBuffableSpell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellBuffEffect
extends EffectData
implements IBuffableSpell {
    public IBuffableSpell buffable;
    private IBuffableSpell.SpellBuffType buff = IBuffableSpell.SpellBuffType.None;

    public SpellBuffEffect(EntityLivingBase source, IBuffableSpell buffable) {
        super(source, null);
        this.canceled = false;
        this.buffable = buffable;
        this.Source = source;
        this.sourceData = Load.Unit((ICapabilityProvider)source);
        WorldData.IWorldData world = Load.World((ICapabilityProvider)source.field_70170_p);
        try {
            this.sourceUnit = this.sourceData.getUnit();
            if (this.sourceUnit != null) {
                this.sourceData.recalculateStats(source, world);
            } else {
                this.canceled = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void activate() {
        this.buffable.setBuff(this.buff);
    }

    @Override
    public void Activate() {
        if (this.Source == null || this.canceled || this.sourceUnit == null || this.sourceData == null) {
            return;
        }
        this.TryApplyEffects(this.GetSource());
        if (!this.canceled) {
            this.sourceData.setUnit(this.sourceUnit, this.Source);
            this.activate();
        }
    }

    @Override
    protected EffectData TryApplyEffects(Unit unit) {
        if (this.canceled) {
            return this;
        }
        SpellBuffEffect Data = this;
        List<EffectUnitStat> Effects = new ArrayList<EffectUnitStat>();
        Effects = this.AddEffects(Effects, unit);
        Effects.sort(new EffectUnitStat());
        for (EffectUnitStat item : Effects) {
            if (item.stat.Value == 0.0f || !this.AffectsThisUnit(item.effect, Data, item.source)) continue;
            item.effect.TryModifyEffect(Data, item.source, item.stat, item.stat.GetStat());
        }
        return Data;
    }

    @Override
    public boolean AffectsThisUnit(IStatEffect effect, EffectData data, Unit source) {
        if (effect.Side().equals((Object)IStatEffect.EffectSides.Target)) {
            return source.equals(data.targetUnit);
        }
        return source.equals(data.sourceUnit);
    }

    private List<EffectUnitStat> AddEffects(List<EffectUnitStat> effects, Unit unit) {
        if (unit != null) {
            for (StatData stat : unit.MyStats.values()) {
                if (!(stat.GetStat() instanceof IStatEffects)) continue;
                for (IStatEffect effect : ((IStatEffects)((Object)stat.GetStat())).GetEffects()) {
                    effects.add(new EffectUnitStat(effect, unit, stat));
                }
            }
        }
        return effects;
    }

    @Override
    public void setBuff(IBuffableSpell.SpellBuffType buff) {
        this.buff = buff;
    }

    @Override
    public IBuffableSpell.SpellBuffType getBuff() {
        return this.buff;
    }

    @Override
    public void setType(BaseSpell.SpellType type) {
        this.buffable.setType(type);
    }

    @Override
    public BaseSpell.SpellType getType() {
        return this.buffable.getType();
    }
}

