/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.gui.mobs;

import com.robertx22.config.ModConfig;
import com.robertx22.saveclasses.Unit;
import com.robertx22.saveclasses.effects.StatusEffectData;
import com.robertx22.uncommon.capability.EntityData;
import com.robertx22.uncommon.datasaving.Load;
import com.robertx22.uncommon.gui.mobs.HealthBarUtils;
import com.robertx22.uncommon.gui.mobs.NeatConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HealthBarRenderer {
    Minecraft mc = Minecraft.func_71410_x();
    List<EntityLivingBase> renderedEntities = new ArrayList<EntityLivingBase>();

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!Minecraft.func_71382_s() || !ModConfig.Client.RENDER_MOB_HEALTH_GUI) {
            return;
        }
        Entity cameraEntity = this.mc.func_175606_aa();
        BlockPos renderingVector = cameraEntity.func_180425_c();
        Frustum frustum = new Frustum();
        float partialTicks = event.getPartialTicks();
        double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks;
        double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks;
        double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks;
        frustum.func_78547_a(viewX, viewY, viewZ);
        if (NeatConfig.showOnlyFocused) {
            Entity focused = HealthBarUtils.getEntityLookedAt((Entity)this.mc.field_71439_g);
            if (focused != null && focused.hasCapability(EntityData.Data, null) && focused.func_70089_S()) {
                try {
                    this.renderHealthBar((EntityLivingBase)focused, partialTicks, cameraEntity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            WorldClient client = this.mc.field_71441_e;
            Set entities = (Set)ObfuscationReflectionHelper.getPrivateValue(WorldClient.class, (Object)client, (String[])new String[]{"entityList", "field_73032_d", "J"});
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof EntityLivingBase) || entity == this.mc.field_71439_g || !entity.func_145770_h((double)renderingVector.func_177958_n(), (double)renderingVector.func_177956_o(), (double)renderingVector.func_177952_p()) || !entity.field_70158_ak && !frustum.func_78546_a(entity.func_174813_aQ()) || !entity.func_70089_S() || !entity.func_184182_bu().isEmpty()) continue;
                this.renderHealthBar((EntityLivingBase)entity, partialTicks, cameraEntity);
            }
        }
    }

    public void renderHealthBar(EntityLivingBase passedEntity, float partialTicks, Entity viewPoint) {
        Stack<EntityLivingBase> ridingStack = new Stack<EntityLivingBase>();
        EntityLivingBase entity = passedEntity;
        ridingStack.push(entity);
        EntityData.UnitData data = Load.Unit((ICapabilityProvider)entity);
        if (data == null) {
            return;
        }
        Unit unit = data.getUnit();
        if (unit == null) {
            return;
        }
        while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityLivingBase) {
            entity = (EntityLivingBase)entity.func_184187_bx();
            ridingStack.push(entity);
        }
        float pastTranslate = 0.0f;
        while (!ridingStack.isEmpty()) {
            boolean useHue;
            entity = (EntityLivingBase)ridingStack.pop();
            boolean boss = !entity.func_184222_aU();
            String entityID = EntityList.func_75621_b((Entity)entity);
            float distance = passedEntity.func_70032_d(viewPoint);
            if (distance > 50.0f || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj()) continue;
            double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
            double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
            double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
            float scale = 0.026666673f;
            if (unit == null || unit.healthData() == null) {
                return;
            }
            float maxHealth = unit.healthData().Value;
            float health = unit.health().CurrentValue(entity, unit);
            if (maxHealth <= 0.0f) continue;
            float percent = (int)(health / maxHealth * 100.0f);
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(x - renderManager.field_78730_l)), (float)((float)(y - renderManager.field_78731_m + (double)passedEntity.field_70131_O + NeatConfig.heightAbove)), (float)((float)(z - renderManager.field_78728_n)));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
            boolean lighting = GL11.glGetBoolean((int)2896);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float padding = NeatConfig.backgroundPadding;
            int bgHeight = NeatConfig.backgroundHeight;
            int barHeight = NeatConfig.barHeight;
            float size = NeatConfig.plateSize;
            int r = 0;
            int g = 255;
            int b = 0;
            if (data.getRarity() > 4) {
                size = NeatConfig.plateSizeBoss;
                r = 128;
                g = 0;
                b = 128;
            }
            boolean bl = useHue = !NeatConfig.colorByType;
            if (useHue) {
                float hue = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
                Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                r = color.getRed();
                g = color.getGreen();
                b = color.getBlue();
            }
            GlStateManager.func_179109_b((float)0.0f, (float)pastTranslate, (float)0.0f);
            float s = 0.5f;
            String name = I18n.func_135052_a((String)data.getName(entity), (Object[])new Object[0]);
            float namel = (float)this.mc.field_71466_p.func_78256_a(name) * s;
            if (namel + 20.0f > size * 2.0f) {
                size = namel / 2.0f + 10.0f;
            }
            float healthSize = size * (health / maxHealth);
            if (NeatConfig.drawBackground) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)(-size - padding), (double)(-bgHeight), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                buffer.func_181662_b((double)(-size - padding), (double)((float)barHeight + padding), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                buffer.func_181662_b((double)(size + padding), (double)((float)barHeight + padding), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                buffer.func_181662_b((double)(size + padding), (double)(-bgHeight), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                tessellator.func_78381_a();
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b((double)(-size), 0.0, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            buffer.func_181662_b((double)(-size), (double)barHeight, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            buffer.func_181662_b((double)size, (double)barHeight, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            buffer.func_181662_b((double)size, 0.0, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b((double)(-size), 0.0, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            buffer.func_181662_b((double)(-size), (double)barHeight, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            buffer.func_181662_b((double)(healthSize * 2.0f - size), (double)barHeight, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            buffer.func_181662_b((double)(healthSize * 2.0f - size), 0.0, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-size), (float)-4.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            this.mc.field_71466_p.func_78276_b(name, 0, 0, 0xFFFFFF);
            GlStateManager.func_179094_E();
            float s1 = 0.75f;
            GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
            int h = NeatConfig.hpTextHeight;
            String maxHpStr = TextFormatting.BOLD + "" + (double)Math.round((double)maxHealth * 100.0) / 100.0;
            String hpStr = "" + (double)Math.round((double)health * 100.0) / 100.0;
            String percStr = (int)percent + "%";
            if (maxHpStr.endsWith(".0")) {
                maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 2);
            }
            if (hpStr.endsWith(".0")) {
                hpStr = hpStr.substring(0, hpStr.length() - 2);
            }
            if (NeatConfig.showCurrentHP) {
                this.mc.field_71466_p.func_78276_b(hpStr, 2, h, 0xFFFFFF);
            }
            if (NeatConfig.showMaxHP) {
                this.mc.field_71466_p.func_78276_b(maxHpStr, (int)(size / (s * s1) * 2.0f) - 2 - this.mc.field_71466_p.func_78256_a(maxHpStr), h, 0xFFFFFF);
            }
            if (NeatConfig.showPercentage) {
                this.mc.field_71466_p.func_78276_b(percStr, (int)(size / (s * s1)) - this.mc.field_71466_p.func_78256_a(percStr) / 2, h, -1);
            }
            if (NeatConfig.enableDebugInfo && this.mc.field_71474_y.field_74330_P) {
                this.mc.field_71466_p.func_78276_b("ID: \"" + entityID + "\"", 0, h + 16, -1);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int off = 0;
            s1 = 0.5f;
            GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
            GlStateManager.func_179109_b((float)(size / (s * s1) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
            this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            for (StatusEffectData statusdata : unit.statusEffects.values()) {
                HealthBarUtils.renderIcon(off, 0, new ItemStack(statusdata.GetEffect().ItemModel()), 16, 16);
                off -= 16;
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            if (lighting) {
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            pastTranslate -= (float)(bgHeight + barHeight) + padding;
        }
    }
}

