/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.gui.mobs;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class HealthBarUtils {
    public static void renderIcon(int vertexX, int vertexY, ItemStack stack, int intU, int intV) {
        try {
            IBakedModel iBakedModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
            TextureAtlasSprite textureAtlasSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(iBakedModel.func_177554_e().func_94215_i());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)vertexX, (double)(vertexY + intV), 0.0).func_187315_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b((double)(vertexX + intU), (double)(vertexY + intV), 0.0).func_187315_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b((double)(vertexX + intU), (double)vertexY, 0.0).func_187315_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b((double)vertexX, (double)vertexY, 0.0).func_187315_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        RayTraceResult pos = HealthBarUtils.raycast(e, 32.0);
        Vec3d positionVector = e.func_174791_d();
        if (e instanceof EntityPlayer) {
            positionVector = positionVector.func_72441_c(0.0, (double)e.func_70047_e(), 0.0);
        }
        if (pos != null) {
            distance = pos.field_72307_f.func_72438_d(positionVector);
        }
        Vec3d lookVector = e.func_70040_Z();
        Vec3d reachVector = positionVector.func_72441_c(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.func_130014_f_().func_72839_b(e, e.func_174813_aQ().func_72314_b(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0).func_72321_a(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.func_70067_L()) {
                double distanceToEntity;
                float collisionBorderSize = entity.func_70111_Y();
                AxisAlignedBB hitbox = entity.func_174813_aQ().func_72321_a((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
                RayTraceResult interceptPosition = hitbox.func_72327_a(positionVector, reachVector);
                if (hitbox.func_72318_a(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition != null && ((distanceToEntity = positionVector.func_72438_d(interceptPosition.field_72307_f)) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    public static RayTraceResult raycast(Entity e, double len) {
        Vec3d look;
        Vec3d vec = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        if (e instanceof EntityPlayer) {
            vec = vec.func_178787_e(new Vec3d(0.0, (double)e.func_70047_e(), 0.0));
        }
        if ((look = e.func_70040_Z()) == null) {
            return null;
        }
        return HealthBarUtils.raycast(e.func_130014_f_(), vec, look, len);
    }

    public static RayTraceResult raycast(World world, Vec3d origin, Vec3d ray, double len) {
        Vec3d end = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        RayTraceResult pos = world.func_72933_a(origin, end);
        return pos;
    }
}

