/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.gui.player_stats;

import com.libraries.rabbit.gui.component.list.ScrollableDisplayList;
import com.libraries.rabbit.gui.component.list.entries.ListEntry;
import com.libraries.rabbit.gui.component.list.entries.StringEntry;
import com.libraries.rabbit.gui.show.Show;
import com.robertx22.database.stat_types.defense.Armor;
import com.robertx22.database.stat_types.defense.Dodge;
import com.robertx22.database.stat_types.elementals.all_damage.AllFireDamage;
import com.robertx22.database.stat_types.elementals.all_damage.AllNatureDamage;
import com.robertx22.database.stat_types.elementals.all_damage.AllThunderDamage;
import com.robertx22.database.stat_types.elementals.all_damage.AllWaterDamage;
import com.robertx22.database.stat_types.elementals.attack_damage.AttackFireDamage;
import com.robertx22.database.stat_types.elementals.attack_damage.AttackNatureDamage;
import com.robertx22.database.stat_types.elementals.attack_damage.AttackThunderDamage;
import com.robertx22.database.stat_types.elementals.attack_damage.AttackWaterDamage;
import com.robertx22.database.stat_types.elementals.pene.FirePene;
import com.robertx22.database.stat_types.elementals.pene.NaturePene;
import com.robertx22.database.stat_types.elementals.pene.ThunderPene;
import com.robertx22.database.stat_types.elementals.pene.WaterPene;
import com.robertx22.database.stat_types.elementals.resist.FireResist;
import com.robertx22.database.stat_types.elementals.resist.NatureResist;
import com.robertx22.database.stat_types.elementals.resist.ThunderResist;
import com.robertx22.database.stat_types.elementals.resist.WaterResist;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellFireDamage;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellNatureDamage;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellThunderDamage;
import com.robertx22.database.stat_types.elementals.spell_damage.SpellWaterDamage;
import com.robertx22.database.stat_types.elementals.spell_to_attack.FireSpellToAttackDMG;
import com.robertx22.database.stat_types.elementals.spell_to_attack.NatureSpellToAttackDMG;
import com.robertx22.database.stat_types.elementals.spell_to_attack.ThunderSpellToAttackDMG;
import com.robertx22.database.stat_types.elementals.spell_to_attack.WaterSpellToAttackDMG;
import com.robertx22.database.stat_types.offense.ArmorPenetration;
import com.robertx22.database.stat_types.offense.CriticalDamage;
import com.robertx22.database.stat_types.offense.CriticalHit;
import com.robertx22.database.stat_types.offense.PhysicalDamage;
import com.robertx22.database.stat_types.offense.weapon_types.AxeDamage;
import com.robertx22.database.stat_types.offense.weapon_types.BowDamage;
import com.robertx22.database.stat_types.offense.weapon_types.HammerDamage;
import com.robertx22.database.stat_types.offense.weapon_types.StaffDamage;
import com.robertx22.database.stat_types.offense.weapon_types.SwordDamage;
import com.robertx22.database.stat_types.resources.EnergyRegen;
import com.robertx22.database.stat_types.resources.HealthRegen;
import com.robertx22.database.stat_types.resources.LifeOnHit;
import com.robertx22.database.stat_types.resources.Lifesteal;
import com.robertx22.database.stat_types.resources.ManaRegen;
import com.robertx22.database.stats.Stat;
import com.robertx22.database.stats.Trait;
import com.robertx22.database.stats.UsableStat;
import com.robertx22.saveclasses.StatData;
import com.robertx22.saveclasses.Unit;
import com.robertx22.uncommon.CLOC;
import com.robertx22.uncommon.capability.EntityData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public class PlayerStatsGui
extends Show {
    Unit unit;
    EntityData.UnitData data;
    Minecraft mc;
    ScrollableDisplayList scroll = null;
    boolean setup = false;

    @Override
    public void setup() {
        super.setup();
        this.mc = Minecraft.func_71410_x();
        if (this.mc != null && this.mc.field_71439_g != null) {
            this.data = (EntityData.UnitData)this.mc.field_71439_g.getCapability(EntityData.Data, null);
            this.unit = this.data.getUnit();
        }
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        try {
            this.scroll = this.displayStats();
            if (this.scroll != null && !this.setup) {
                this.scroll.setup();
                this.setup = true;
                this.scroll.setVisibleBackground(true);
                this.registerComponent(this.scroll);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ScrollableDisplayList displayStats() {
        if (this.unit != null && this.mc.field_71462_r != null) {
            ArrayList<Stat> stats = new ArrayList<Stat>();
            ArrayList<ListEntry> list = new ArrayList<ListEntry>();
            for (StatData data : this.unit.MyStats.values()) {
                stats.add(data.GetStat());
            }
            this.ShowStat(TextFormatting.GREEN + CLOC.word("resources") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.healthData(), stats), list);
            this.ShowStat(this.GetStatString(this.unit.manaData(), stats), list);
            this.ShowStat(this.GetStatString(this.unit.energyData(), stats), list);
            this.ShowStat(TextFormatting.YELLOW + CLOC.word("regen") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(HealthRegen.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(ManaRegen.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(EnergyRegen.GUID), stats), list);
            this.ShowStat(TextFormatting.RED + CLOC.word("attack") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(PhysicalDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(CriticalDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(CriticalHit.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(Lifesteal.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(LifeOnHit.GUID), stats), list);
            this.ShowStat(TextFormatting.RED + CLOC.word("spell_damage") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(SpellFireDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(SpellWaterDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(SpellThunderDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(SpellNatureDamage.GUID), stats), list);
            this.ShowStat(TextFormatting.RED + CLOC.word("element_attack_damage") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AttackFireDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AttackWaterDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AttackThunderDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AttackNatureDamage.GUID), stats), list);
            this.ShowStat(TextFormatting.RED + CLOC.word("bonus_all_ele_dmg") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AllFireDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AllWaterDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AllThunderDamage.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(AllNatureDamage.GUID), stats), list);
            this.ShowStat(TextFormatting.RED + CLOC.word("spell_to_attack_conversion") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(FireSpellToAttackDMG.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(WaterSpellToAttackDMG.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(ThunderSpellToAttackDMG.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(NatureSpellToAttackDMG.GUID), stats), list);
            this.ShowStat(TextFormatting.BLUE + CLOC.word("defenses") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(Armor.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(Dodge.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(FireResist.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(WaterResist.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(ThunderResist.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(NatureResist.GUID), stats), list);
            this.ShowStat(TextFormatting.LIGHT_PURPLE + CLOC.word("penetration") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(ArmorPenetration.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(FirePene.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(WaterPene.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(ThunderPene.GUID), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(NaturePene.GUID), stats), list);
            this.ShowStat(TextFormatting.BLUE + CLOC.word("weapon_damage") + ": ", list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(new HammerDamage().GUID()), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(new AxeDamage().GUID()), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(new BowDamage().GUID()), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(new SwordDamage().GUID()), stats), list);
            this.ShowStat(this.GetStatString(this.unit.MyStats.get(new StaffDamage().GUID()), stats), list);
            this.ShowStat(TextFormatting.GOLD + CLOC.word("misc") + ": ", list);
            for (StatData data : this.unit.MyStats.values()) {
                this.ShowStat(this.GetStatString(data, stats), list);
            }
            int width = this.width / 2;
            int height = this.height - this.height / 5;
            ScrollableDisplayList scroll = new ScrollableDisplayList(this.width / 4, this.height / 10, width, height, 15, list);
            return scroll;
        }
        return null;
    }

    private void ShowStat(String str, List<ListEntry> list) {
        if (str != null) {
            StringEntry entry = new StringEntry(str);
            list.add(entry);
        }
    }

    private String GetStatString(StatData data, List<Stat> stats) {
        if (!stats.contains(data.GetStat())) {
            return null;
        }
        stats.remove(data.GetStat());
        String str = data.GetStat().localizedString() + " " + String.format("%.1f", Float.valueOf(data.Value));
        if (data.GetStat().IsPercent()) {
            str = str + "%";
        }
        if (data.GetStat() instanceof UsableStat) {
            UsableStat usable = (UsableStat)data.GetStat();
            return str + " (" + String.format("%.2f", Float.valueOf(usable.GetUsableValue(this.data.getLevel(), (int)data.Value) * 100.0f)) + "%)";
        }
        if (data.GetStat() instanceof Trait) {
            return null;
        }
        return str;
    }
}

