/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.uncommon.structures;

import com.robertx22.uncommon.SLOC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public abstract class BaseStructureGen {
    ResourceLocation res;
    BlockPos pos;
    World world;
    ITemplateProcessor processor;

    abstract String chatUnlocAnnouncement();

    public BaseStructureGen(ResourceLocation structure, BlockPos pos, World world, ITemplateProcessor processor) {
        this.res = structure;
        this.pos = pos;
        this.world = world;
        this.processor = processor;
    }

    public void generate() {
        try {
            PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.NONE);
            Template template = this.world.func_72860_G().func_186340_h().func_186237_a(this.world.func_73046_m(), this.res);
            if (this.processor != null) {
                template.func_189960_a(this.world, this.pos, this.processor, settings, 2);
            } else {
                template.func_186253_b(this.world, this.pos, settings);
            }
            this.announce();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void announce() {
        for (EntityPlayer player : this.world.field_73010_i) {
            player.func_145747_a((ITextComponent)SLOC.chat(this.chatUnlocAnnouncement()));
        }
    }
}

