/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.installer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Json {

    public static class JsObject
    extends JsValue {
        ArrayList<JsField> members = new ArrayList();
        Map<String, JsField> membersMap = new HashMap<String, JsField>();

        @Override
        void print(Writer wr, int indent) throws IOException {
            wr.append("{");
            int indent1 = indent + 1;
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                JsField m = this.members.get(i);
                this.println(wr, indent1);
                m.print(wr, indent1);
                if (i + 1 >= n) continue;
                wr.append(",");
            }
            this.println(wr, indent);
            wr.append("}");
        }

        void put(String name, JsValue value) {
            JsField jsf = this.membersMap.get(name);
            if (jsf == null) {
                jsf = new JsField();
                jsf.name = name;
                jsf.value = value;
                this.members.add(jsf);
                this.membersMap.put(name, jsf);
            } else {
                jsf.value = value;
            }
        }

        JsValue get(String name) {
            JsField jsf = this.membersMap.get(name);
            if (jsf == null) {
                return null;
            }
            return jsf.value;
        }
    }

    public static class JsField
    extends JsValue {
        String name;
        JsValue value;

        @Override
        void print(Writer wr, int indent) throws IOException {
            wr.append("\"").append(this.name).append("\": ");
            this.value.print(wr, indent);
        }
    }

    public static class JsArray
    extends JsValue {
        ArrayList<JsValue> elements = new ArrayList();

        @Override
        void print(Writer wr, int indent) throws IOException {
            wr.append("[");
            int indent1 = indent + 1;
            int n = this.elements.size();
            for (int i = 0; i < n; ++i) {
                JsValue e = this.elements.get(i);
                this.println(wr, indent1);
                e.print(wr, indent1);
                if (i + 1 >= n) continue;
                wr.append(",");
            }
            this.println(wr, indent);
            wr.append("]");
        }
    }

    public static class JsBoolean
    extends JsValue {
        String str;

        public JsBoolean() {
        }

        public JsBoolean(String str) {
            this.str = str;
        }

        @Override
        void print(Writer wr, int indent) throws IOException {
            wr.append(this.str);
        }
    }

    public static class JsNumber
    extends JsValue {
        String str;

        @Override
        void print(Writer wr, int indent) throws IOException {
            wr.append(this.str);
        }
    }

    public static class JsString
    extends JsValue {
        String str;

        public JsString() {
        }

        public JsString(String str) {
            this.str = str;
        }

        @Override
        void print(Writer wr, int indent) throws IOException {
            wr.append("\"").append(this.str).append("\"");
        }
    }

    public static class JsValue {
        void print(Writer wr, int indent) throws IOException {
        }

        void println(Writer wr, int indent) throws IOException {
            wr.append("\n");
            for (int i = 0; i < indent; ++i) {
                wr.append("  ");
            }
        }
    }
}

