/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmod.common.SMCEnvironment;
import shadersmod.common.SMCLog;
import shadersmod.transform.AccessorGenerator;
import shadersmod.transform.Names;

public class SMCCTEntityRenderer
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVrenderWorldPass
    extends MethodVisitor {
        MethodVisitor mvOut;
        Label labelNoSky = null;
        Label labelEndRender = null;

        public MVrenderWorldPass(MethodVisitor mv) {
            super(262144);
            this.mvOut = mv;
            this.setNextState(new State0());
        }

        void setNextState(MethodVisitor next) {
            this.mv = next;
        }

        class StateEnd
        extends MVState {
            StateEnd() {
            }

            @Override
            public void visitEnd() {
                this.mv.visitEnd();
            }
        }

        class State99
        extends MVState {
            State99() {
            }

            void a() {
                MVrenderWorldPass.this.setNextState(new State99());
            }
        }

        class State31
        extends MVState {
            State31() {
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                this.mv.visitFrame(type, nLocal, local, nStack, stack);
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endRender", "()V");
                MVrenderWorldPass.this.setNextState(new StateEnd());
            }
        }

        class State30
        extends MVState {
            State30() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.entityRenderer_renderHand.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "renderFPOverlay", "(" + Names.entityRenderer_.desc + "FI)V");
                    MVrenderWorldPass.this.setNextState(new State31());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State29
        extends MVState {
            State29() {
            }

            public void visitVarInsn(int opcode, int var) {
                if (opcode == 25) {
                    this.mv.visitVarInsn(opcode, var);
                    MVrenderWorldPass.this.setNextState(new State30());
                } else {
                    this.mv.visitVarInsn(opcode, var);
                }
            }
        }

        class State28
        extends MVState {
            State28() {
            }

            public void visitJumpInsn(int opcode, Label label) {
                if (opcode == 153) {
                    this.mv.visitJumpInsn(opcode, label);
                    this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isShadowPass", "Z");
                    this.mv.visitJumpInsn(154, label);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(23, 2);
                    this.mv.visitVarInsn(21, 1);
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "renderHand1", "(" + Names.entityRenderer_.desc + "FI)V");
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "renderCompositeFinal", "()V");
                    MVrenderWorldPass.this.setNextState(new State29());
                } else {
                    this.mv.visitJumpInsn(opcode, label);
                }
            }
        }

        class State23
        extends MVState {
            State23() {
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (Names.entityRenderer_shouldRenderHand.equals(owner, name)) {
                    this.mv.visitFieldInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State28());
                } else {
                    this.mv.visitFieldInsn(opcode, owner, name, desc);
                }
            }
        }

        class State22
        extends MVState {
            State22() {
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                this.mv.visitFrame(type, nLocal, local, nStack, stack);
                MVrenderWorldPass.this.setNextState(new State23());
            }
        }

        class State21
        extends MVState {
            State21() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.entityRenderer_renderCloudsCheck.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State22());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State19
        extends MVState {
            State19() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderBlockLayer4.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginWater", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endWater", "()V");
                    MVrenderWorldPass.this.setNextState(new State21());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State18
        extends MVState {
            State18() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderBlockLayer4.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginWater", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endWater", "()V");
                    MVrenderWorldPass.this.setNextState(new State19());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State17
        extends MVState {
            State17() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.glStateManager_depthMask.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(23, 2);
                    this.mv.visitVarInsn(21, 1);
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "renderHand0", "(" + Names.entityRenderer_.desc + "FI)V");
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "preWater", "()V");
                    MVrenderWorldPass.this.setNextState(new State18());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State16
        extends MVState {
            State16() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.entityRenderer_renderRainSnow.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginWeather", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endWeather", "()V");
                    MVrenderWorldPass.this.setNextState(new State17());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State14
        extends MVState {
            State14() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.effectRenderer_renderParticles.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginParticles", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endParticles", "()V");
                    MVrenderWorldPass.this.setNextState(new State16());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State13
        extends MVState {
            State13() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.effectRenderer_renderLitParticles.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginLitParticles", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State14());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State12c
        extends MVState {
            State12c() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderEntities.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State13());
                } else if (owner.equals(Names.ofReflector_.clasName)) {
                    SMCEnvironment.hasOptiFine = true;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                } else if (owner.equals(Names.forgeHooksClient_.clasName)) {
                    SMCEnvironment.hasForge = true;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State12b
        extends MVState {
            State12b() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderBlockLayer4.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "beginTerrainCutout", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "endTerrain", "()V");
                    MVrenderWorldPass.this.setNextState(new State12c());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State12a
        extends MVState {
            State12a() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderBlockLayer4.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "beginTerrainCutoutMipped", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State12b());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State12
        extends MVState {
            State12() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderBlockLayer4.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "beginTerrainSolid", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State12a());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State11
        extends MVState {
            State11() {
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                this.mv.visitFrame(type, nLocal, local, nStack, stack);
                MVrenderWorldPass.this.setNextState(new State12());
            }
        }

        class State10
        extends MVState {
            State10() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_updateChunks.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "updateChunks", "(" + Names.renderGlobal_.desc + "J)V");
                    MVrenderWorldPass.this.setNextState(new State11());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State9
        extends MVState {
            State9() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_setupTerrain.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "setupTerrain", "(" + Names.renderGlobal_.desc + Names.entity_.desc + "D" + Names.iCamera_.desc + "IZ)V");
                    MVrenderWorldPass.this.setNextState(new State10());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State8
        extends MVState {
            State8() {
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                this.mv.visitFrame(type, nLocal, local, nStack, stack);
                MVrenderWorldPass.this.setNextState(new State9());
            }
        }

        class State7
        extends State8 {
            State7() {
            }

            @Override
            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                this.mv.visitLabel(MVrenderWorldPass.this.labelNoSky);
                MVrenderWorldPass.this.labelNoSky = null;
                super.visitFrame(type, nLocal, local, nStack, stack);
            }
        }

        class State6
        extends MVState {
            State6() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderSky.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginSky", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endSky", "()V");
                    MVrenderWorldPass.this.setNextState(new State7());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State5
        extends MVState {
            State5() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderSky.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginSky", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endSky", "()V");
                    MVrenderWorldPass.this.setNextState(new State8());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State4
        extends MVState {
            State4() {
            }

            public void visitJumpInsn(int opcode, Label label) {
                if (opcode == 161) {
                    this.mv.visitInsn(88);
                    this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isShadowPass", "Z");
                    this.mv.visitJumpInsn(154, label);
                    MVrenderWorldPass.this.setNextState(new State5());
                } else {
                    this.mv.visitJumpInsn(opcode, label);
                }
            }
        }

        class State3
        extends MVState {
            State3() {
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (Names.gameSettings_renderDistance.equals(owner, name)) {
                    this.mv.visitFieldInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State4());
                } else {
                    this.mv.visitFieldInsn(opcode, owner, name, desc);
                }
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.equals("Config", "isSkyEnabled", "()Z", owner, name, desc)) {
                    this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isShadowPass", "Z");
                    MVrenderWorldPass.this.labelNoSky = new Label();
                    this.mv.visitJumpInsn(154, MVrenderWorldPass.this.labelNoSky);
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State6());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State2b
        extends MVState {
            State2b() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.iCamera_setPosition.equals(owner, name, desc) || Names.frustrum_setPosition.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "setFrustrumPosition", "(" + Names.frustum_.desc + "DDD)V");
                    MVrenderWorldPass.this.setNextState(new State3());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State2a
        extends MVState {
            State2a() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.equals(Names.frustum_.clasName, "<init>", "()V", owner, name, desc)) {
                    boolean mod = false;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderWorldPass.this.setNextState(new State2b());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State2
        extends MVState {
            State2() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.entityRenderer_setupCameraTransform.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitVarInsn(23, 2);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "setCamera", "(F)V");
                    MVrenderWorldPass.this.setNextState(new State2a());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State1
        extends MVState {
            State1() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.glStateManager_clear.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "clearRenderBuffer", "()V");
                    MVrenderWorldPass.this.setNextState(new State2());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State0
        extends MVState {
            State0() {
            }

            public void visitCode() {
                this.mv.visitCode();
                this.mv.visitVarInsn(21, 1);
                this.mv.visitVarInsn(23, 2);
                this.mv.visitVarInsn(22, 3);
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginRenderPass", "(IFJ)V");
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.glStateManager_viewport.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "setViewport", "(IIII)V");
                    MVrenderWorldPass.this.setNextState(new State1());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class MVState
        extends MethodVisitor {
            public MVState() {
                super(262144, MVrenderWorldPass.this.mvOut);
            }

            public void visitEnd() {
                if (((Object)((Object)this)).getClass() != StateEnd.class) {
                    SMCLog.severe("  ends in bad state %s", ((Object)((Object)this)).getClass().getSimpleName());
                }
                this.mv.visitEnd();
            }
        }
    }

    private static class MVrenderWorld
    extends MethodVisitor {
        int state = 0;

        public MVrenderWorld(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            switch (this.state) {
                case 0: {
                    if (!Names.entityRenderer_getMouseOver.equals(owner, name, desc)) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, Names.entityRenderer_mc.clasName, Names.entityRenderer_mc.name, Names.entityRenderer_mc.desc);
                    this.mv.visitVarInsn(23, 1);
                    this.mv.visitVarInsn(22, 2);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginRender", "(" + Names.minecraft_.desc + "FJ)V");
                    return;
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVrenderHand
    extends MethodVisitor {
        Label la1 = new Label();
        Label la2 = new Label();

        public MVrenderHand(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (Names.equals("org/lwjgl/util/glu/Project", "gluPerspective", "(FFFF)V", owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "applyHandDepth", "()V");
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            if (Names.glStateManager_pushMatrix.equals(owner, name, desc)) {
                this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isSleeping", "Z");
                this.mv.visitVarInsn(54, 4);
                this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isHandRendered", "Z");
                this.mv.visitJumpInsn(154, this.la1);
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            if (Names.glStateManager_popMatrix.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitLabel(this.la1);
                this.mv.visitFrame(3, 0, null, 0, null);
                this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isCompositeRendered", "Z");
                this.mv.visitJumpInsn(154, this.la2);
                this.mv.visitInsn(177);
                this.mv.visitLabel(this.la2);
                this.mv.visitFrame(3, 0, null, 0, null);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, Names.entityRenderer_disableLightmap.clasName, Names.entityRenderer_disableLightmap.name, Names.entityRenderer_disableLightmap.desc);
                return;
            }
            if (Names.itemRenderer_renderItemInFirstPerson.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "renderItemFP", "(" + Names.itemRenderer_.desc + "F)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVrenderCloudsCheck
    extends MethodVisitor {
        public MVrenderCloudsCheck(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (Names.gameSettings_shouldRenderClouds.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "shouldRenderClouds", "(" + Names.gameSettings_.desc + ")Z");
                return;
            }
            if (Names.renderGlobal_renderClouds.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginClouds", "()V");
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endClouds", "()V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVsetupFog
    extends MethodVisitor {
        public MVsetupFog(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (Names.glStateManager_setFog.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "setFog", "(I)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVsetFogColorBuffer
    extends MethodVisitor {
        public MVsetFogColorBuffer(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(23, 1);
            this.mv.visitVarInsn(23, 2);
            this.mv.visitVarInsn(23, 3);
            this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "setFogColor", "(FFF)V");
        }
    }

    private static class MVupdateFogColor
    extends MethodVisitor {
        public MVupdateFogColor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (Names.glStateManager_clearColor.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "setClearColor", "(FFFF)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVenableLightmap
    extends MethodVisitor {
        public MVenableLightmap(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "enableLightmap", "()V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVdisableLightmap
    extends MethodVisitor {
        public MVdisableLightmap(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "disableLightmap", "()V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Names.entityRenderer_disableLightmap.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVdisableLightmap(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_enableLightmap.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVenableLightmap(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_updateFogColor.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVupdateFogColor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_setFogColorBuffer.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVsetFogColorBuffer(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_setupFog.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVsetupFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_renderCloudsCheck.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderCloudsCheck(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_renderHand.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderHand(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_renderWorld.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderWorld(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.entityRenderer_renderWorldPass.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderWorldPass(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            AccessorGenerator.generateFieldAccessor(this.cv, "frameCount", Names.entityRenderer_frameCount);
            AccessorGenerator.generatePrivateMethodAccessor(this.cv, "renderHand", Names.entityRenderer_renderHand);
            AccessorGenerator.generatePrivateMethodAccessor(this.cv, "setupCameraTransform", Names.entityRenderer_setupCameraTransform);
            super.visitEnd();
        }
    }
}

