/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import shadersmod.common.SMCLog;
import shadersmod.transform.Names;

public class SMCCTFaceBakery
implements IClassTransformer {
    private static final int vertexSize = 14;

    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MV178401
    extends MethodVisitor {
        int count = 0;

        public MV178401(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 && operand == 7) {
                this.mv.visitIntInsn(opcode, 14);
                ++this.count;
                if (this.count > 2) {
                    SMCLog.warning("Unexpected number of 7.");
                }
                return;
            }
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    private static class MV178408
    extends MethodVisitor {
        int count = 0;

        public MV178408(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 && operand == 7) {
                this.mv.visitIntInsn(opcode, 14);
                ++this.count;
                if (this.count > 3) {
                    SMCLog.warning("Unexpected number of 7.");
                }
                return;
            }
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    private static class MVgetFacing
    extends MethodVisitor {
        int count = 0;

        public MVgetFacing(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 && operand >= 7 && operand <= 16) {
                this.mv.visitIntInsn(opcode, operand / 7 * 14 + operand % 7);
                ++this.count;
                if (this.count > 6) {
                    SMCLog.warning("Unexpected number of 7-16.");
                }
                return;
            }
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    private static class MVstoreVertex
    extends MethodVisitor {
        int count = 0;

        public MVstoreVertex(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 && operand == 7) {
                this.mv.visitIntInsn(opcode, 14);
                ++this.count;
                if (this.count > 1) {
                    SMCLog.warning("Unexpected number of 7.");
                }
                return;
            }
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    private static class MVmakeQuadVertexData
    extends MethodVisitor {
        int count = 0;

        public MVmakeQuadVertexData(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 && operand == 28) {
                this.mv.visitIntInsn(opcode, 56);
                ++this.count;
                if (this.count > 1) {
                    SMCLog.warning("Unexpected number of 28.");
                }
                return;
            }
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Names.faceBakery_makeQuadVertexData.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVmakeQuadVertexData(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.faceBakery_makeQuadVertexDataForge.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVmakeQuadVertexData(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.faceBakery_storeVertexData.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVstoreVertex(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.faceBakery_getFacingFromVertexData.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVgetFacing(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.faceBakery_func_178408.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MV178408(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.faceBakery_func_178401.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MV178401(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

