/*
 * Decompiled with CFR 0.152.
 */
package radixcore.core;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.modules.client.RadixRender;
import radixcore.modules.datawatcher.IWatchable;
import radixcore.packets.PacketDataSyncReq;
import radixcore.packets.PacketPostLogin;

public class RadixEvents {
    @SubscribeEvent
    public void renderGameOverlayEventHandler(RenderGameOverlayEvent.Text event) {
        if (RadixCore.isTesting) {
            RadixRender.drawTextPopup("RADIXCORE RENDER HELPER TEST", 5, 5);
        }
    }

    @SubscribeEvent
    public void rightClickBlockEventHandler(PlayerInteractEvent.RightClickBlock event) {
        if (RadixCore.isTesting) {
            EntityPlayer player = event.getEntityPlayer();
            World world = player.func_130014_f_();
            BlockPos blockPos = event.getPos();
            IBlockState state = world.func_180495_p(blockPos);
            StringBuilder message = new StringBuilder();
            message.append(state.toString());
            message.append(" @");
            message.append(blockPos.toString().replace("BlockPos", ""));
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a76[\u00a74RadixCore\u00a76] \u00a7r" + message.toString()));
        }
    }

    @SubscribeEvent
    public void playerLoggedInEventHandler(PlayerEvent.PlayerLoggedInEvent event) {
        if (RadixCore.allowUpdateChecking && event.player.func_70613_aW()) {
            RadixCore.getPacketHandler().sendPacketToPlayer(new PacketPostLogin(), event.player);
        }
    }

    @SubscribeEvent
    public void entitySpawnedEvent(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof IWatchable) {
            RadixCore.getPacketHandler().sendPacketToServer(new PacketDataSyncReq(event.getEntity().func_145782_y()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTickEventHandler(TickEvent.ClientTickEvent event) {
        for (ModMetadataEx exData : RadixCore.getRegisteredMods()) {
            if (exData.packetHandler == null) continue;
            exData.packetHandler.processPackets(Side.CLIENT);
        }
    }

    @SubscribeEvent
    public void serverTickEventHandler(TickEvent.ServerTickEvent event) {
        for (ModMetadataEx exData : RadixCore.getRegisteredMods()) {
            if (exData.packetHandler == null) continue;
            exData.packetHandler.processPackets(Side.SERVER);
        }
    }
}

