/*
 * Decompiled with CFR 0.152.
 */
package radixcore.math;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import radixcore.modules.RadixMath;

public final class Point3D
implements Comparable {
    public static final Point3D ZERO = new Point3D(0, 0, 0);
    public static final Point3D NONE = new Point3D(true);
    private int iPosX;
    private int iPosY;
    private int iPosZ;
    private float fPosX;
    private float fPosY;
    private float fPosZ;
    private double dPosX;
    private double dPosY;
    private double dPosZ;
    private boolean noneFlag;

    public Point3D(int posX, int posY, int posZ) {
        this((double)posX, (double)posY, (double)posZ);
    }

    public Point3D(float posX, float posY, float posZ) {
        this((double)posX, (double)posY, (double)posZ);
    }

    public Point3D(double posX, double posY, double posZ) {
        this.iPosX = (int)posX;
        this.iPosY = (int)posY;
        this.iPosZ = (int)posZ;
        this.fPosX = (float)posX;
        this.fPosY = (float)posY;
        this.fPosZ = (float)posZ;
        this.dPosX = posX;
        this.dPosY = posY;
        this.dPosZ = posZ;
    }

    private Point3D(boolean noneFlag) {
        this(0.0, 0.0, 0.0);
        this.noneFlag = noneFlag;
    }

    public void set(int posX, int posY, int posZ) {
        this.fallthroughSet(posX, posY, posZ);
    }

    public void set(float posX, float posY, float posZ) {
        this.fallthroughSet(posX, posY, posZ);
    }

    public void set(double posX, double posY, double posZ) {
        this.fallthroughSet(posX, posY, posZ);
    }

    private void fallthroughSet(double posX, double posY, double posZ) {
        this.iPosX = (int)posX;
        this.iPosY = (int)posY;
        this.iPosZ = (int)posZ;
        this.fPosX = (float)posX;
        this.fPosY = (float)posY;
        this.fPosZ = (float)posZ;
        this.dPosX = posX;
        this.dPosY = posY;
        this.dPosZ = posZ;
    }

    public Point3D setNew(int posX, int posY, int posZ) {
        return new Point3D(posX, posY, posZ);
    }

    public Point3D setNew(float posX, float posY, float posZ) {
        return new Point3D(posX, posY, posZ);
    }

    public Point3D setNew(double posX, double posY, double posZ) {
        return new Point3D(posX, posY, posZ);
    }

    public double dX() {
        return this.dPosX;
    }

    public double dY() {
        return this.dPosY;
    }

    public double dZ() {
        return this.dPosZ;
    }

    public float fX() {
        return this.fPosX;
    }

    public float fY() {
        return this.fPosY;
    }

    public float fZ() {
        return this.fPosZ;
    }

    public int iX() {
        return this.iPosX;
    }

    public int iY() {
        return this.iPosY;
    }

    public int iZ() {
        return this.iPosZ;
    }

    public boolean isNone() {
        return this.noneFlag;
    }

    public static Point3D fromBlockPos(BlockPos pos) {
        return new Point3D(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static Point3D fromEntityPosition(Entity entity) {
        return new Point3D(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static Point3D getNearestPointInList(Point3D refPoint, List<Point3D> pointList) {
        Point3D returnPoint = null;
        double lastDistance = Double.MAX_VALUE;
        for (Point3D point : pointList) {
            double distanceTo = RadixMath.getDistanceToXYZ(refPoint.iPosX, refPoint.iPosY, refPoint.iPosZ, point.iPosX, point.iPosY, point.iPosZ);
            if (!(distanceTo < lastDistance)) continue;
            returnPoint = point;
            lastDistance = distanceTo;
        }
        return returnPoint;
    }

    public static Point3D getFurthestPointInList(Point3D refPoint, List<Point3D> pointList) {
        Point3D returnPoint = null;
        double lastDistance = 0.0;
        for (Point3D point : pointList) {
            double distanceTo = RadixMath.getDistanceToXYZ(refPoint.iPosX, refPoint.iPosY, refPoint.iPosZ, point.iPosX, point.iPosY, point.iPosZ);
            if (!(distanceTo > lastDistance)) continue;
            returnPoint = point;
            lastDistance = distanceTo;
        }
        return returnPoint;
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74780_a(name + "dPosX", this.dPosX);
        nbt.func_74780_a(name + "dPosY", this.dPosY);
        nbt.func_74780_a(name + "dPosZ", this.dPosZ);
    }

    public static Point3D readFromNBT(String name, NBTTagCompound nbt) {
        double x = nbt.func_74769_h(name + "dPosX");
        double y = nbt.func_74769_h(name + "dPosY");
        double z = nbt.func_74769_h(name + "dPosZ");
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return ZERO;
        }
        return new Point3D(x, y, z);
    }

    public String toString() {
        return this.dPosX + ", " + this.dPosY + ", " + this.dPosZ;
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.iPosX, this.iPosY, this.iPosZ);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point3D) {
            Point3D point = (Point3D)obj;
            return point.dPosX == this.dPosX && point.dPosY == this.dPosY && point.dPosZ == this.dPosZ;
        }
        return false;
    }

    public int compareTo(Object obj) {
        Point3D point = (Point3D)obj;
        if (this.iPosY > point.iPosY) {
            return 1;
        }
        if (this.iPosY == point.iPosY) {
            if (this.iPosX > point.iPosX) {
                return 1;
            }
            if (this.iPosX == point.iPosX) {
                if (this.iPosZ > point.iPosZ) {
                    return 1;
                }
                if (this.iPosZ == point.iPosZ) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }
}

