/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import radixcore.math.Point3D;

public final class RadixBlocks {
    public static void setBlock(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state);
    }

    public static void setBlock(World world, Point3D point, Block block) {
        RadixBlocks.setBlock(world, point.toBlockPos(), block.func_176223_P());
    }

    public static void setBlock(World world, int posX, int posY, int posZ, Block block) {
        RadixBlocks.setBlock(world, new BlockPos(posX, posY, posZ), block.func_176223_P());
    }

    public static void setBlock(World world, BlockPos pos, Block block) {
        RadixBlocks.setBlock(world, pos, block.func_176223_P());
    }

    public static <T extends Comparable<T>> void setBlock(World world, BlockPos pos, Block block, IProperty<T> property, T value) {
        RadixBlocks.setBlock(world, pos, block.func_176223_P().func_177226_a(property, value));
    }

    public static <T extends Comparable<T>> void setBlock(World world, Point3D point, Block block, IProperty<T> property, T value) {
        RadixBlocks.setBlock(world, point.toBlockPos(), block, property, value);
    }

    public static <T extends Comparable<T>> void setBlock(World world, int posX, int posY, int posZ, Block block, IProperty<T> property, T value) {
        RadixBlocks.setBlock(world, new BlockPos(posX, posY, posZ), block.func_176223_P().func_177226_a(property, value));
    }

    public static Block getBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static Block getBlock(World world, Point3D point) {
        return RadixBlocks.getBlock(world, point.toBlockPos());
    }

    public static Block getBlock(World world, int posX, int posY, int posZ) {
        return RadixBlocks.getBlock(world, new BlockPos(posX, posY, posZ));
    }

    public static IBlockState getBlockState(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
    }

    public static IBlockState getBlockState(World world, Point3D point) {
        return RadixBlocks.getBlockState(world, point.toBlockPos());
    }

    public static IBlockState getBlockState(World world, int posX, int posY, int posZ) {
        return RadixBlocks.getBlockState(world, new BlockPos(posX, posY, posZ));
    }

    public static <T extends Comparable<T>> boolean blockHasState(World world, BlockPos pos, IProperty<T> property, T value) {
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        return state.equals(world.func_180495_p(pos).func_177230_c().func_176223_P().func_177226_a(property, value));
    }

    public static <T extends Comparable<T>> boolean blockHasState(World world, Point3D point, IProperty<T> property, T value) {
        return RadixBlocks.blockHasState(world, point.toBlockPos(), property, value);
    }

    public static <T extends Comparable<T>> boolean blockHasState(World world, int posX, int posY, int posZ, IProperty<T> property, T value) {
        return RadixBlocks.blockHasState(world, new BlockPos(posX, posY, posZ), property, value);
    }

    private RadixBlocks() {
    }
}

