/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixMath;

public final class RadixLogic {
    private RadixLogic() {
    }

    public static <E extends Entity> E getEntityOfTypeAtXYZ(Class<E> type, World world, int x, int y, int z) {
        for (Entity entity : world.field_72996_f) {
            if (!type.isInstance(type)) continue;
            int posX = (int)entity.field_70165_t;
            int posY = (int)entity.field_70163_u;
            int posZ = (int)entity.field_70161_v;
            if (x != posX || y != posY || z != posZ) continue;
            return (E)entity;
        }
        Entity nearestEntity = null;
        for (E obj : RadixLogic.getEntitiesWithinDistance(type, world, x, y, z, 5)) {
            if (!type.isInstance(obj)) continue;
            if (nearestEntity == null) {
                nearestEntity = (Entity)obj;
                continue;
            }
            Entity otherEntity = (Entity)obj;
            double nearestEntityDistance = RadixMath.getDistanceToXYZ(nearestEntity.field_70165_t, nearestEntity.field_70163_u, nearestEntity.field_70161_v, x, y, z);
            double nearestCandidateDistance = RadixMath.getDistanceToXYZ(otherEntity.field_70165_t, otherEntity.field_70163_u, otherEntity.field_70161_v, x, y, z);
            if (nearestEntityDistance == 1.0) {
                return (E)nearestEntity;
            }
            if (nearestCandidateDistance == 1.0) {
                return (E)otherEntity;
            }
            if (!(nearestCandidateDistance < nearestEntityDistance)) continue;
            nearestEntity = otherEntity;
        }
        return (E)nearestEntity;
    }

    public static <E extends Entity> E getEntityOfTypeAtXYZ(Class<E> type, World world, Point3D point) {
        return RadixLogic.getEntityOfTypeAtXYZ(type, world, point.iX(), point.iY(), point.iZ());
    }

    public static <E extends Entity> E getClosestEntity(Point3D point, World world, int range, @Nullable Class<E> type, @Nullable Entity entityExcluded) {
        ArrayList<Entity> validEntities = new ArrayList<Entity>();
        double posX = point.dX();
        double posY = point.dY();
        double posZ = point.dZ();
        List entitiesAroundMe = world.func_72839_b(entityExcluded, new AxisAlignedBB(posX - (double)range, posY - (double)range, posZ - (double)range, posX + (double)range, posY + (double)range, posZ + (double)range));
        int indexToReturn = -1;
        double lastMinDistance = 100.0;
        if (type == null) {
            type = Entity.class;
        }
        for (Entity entityNearMe : entitiesAroundMe) {
            if (!type.isInstance(entityNearMe)) continue;
            validEntities.add(entityNearMe);
        }
        for (int i = 0; i < validEntities.size(); ++i) {
            Entity entity = (Entity)validEntities.get(i);
            double distance = RadixMath.getDistanceToXYZ(point.dX(), point.dY(), point.dZ(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(distance < lastMinDistance)) continue;
            lastMinDistance = distance;
            indexToReturn = i;
        }
        if (indexToReturn == -1) {
            return null;
        }
        return (E)((Entity)validEntities.get(indexToReturn));
    }

    public static <E extends Entity> E getClosestEntityExclusive(Entity entityOrigin, int range, @Nullable Class<E> type) {
        return RadixLogic.getClosestEntity(Point3D.fromEntityPosition(entityOrigin), entityOrigin.field_70170_p, range, type, entityOrigin);
    }

    public static <E extends Entity> E getClosestEntityInclusive(Entity entityOrigin, int range, @Nullable Class<E> type) {
        return RadixLogic.getClosestEntity(Point3D.fromEntityPosition(entityOrigin), entityOrigin.field_70170_p, range, type, null);
    }

    public static Point3D getNearestBlock(Point3D origin, World world, int horizontalRange, int verticalRange, Block blockType) {
        Point3D returnPoint = Point3D.NONE;
        double closest = 100.0;
        for (Point3D point : RadixLogic.getNearbyBlocks(origin, world, blockType, horizontalRange, verticalRange)) {
            double distance = RadixMath.getDistanceToXYZ(origin.dX(), origin.dY(), origin.dZ(), point.dX(), point.dY(), point.dZ());
            if (!(distance < closest)) continue;
            closest = distance;
            returnPoint = point;
        }
        return returnPoint;
    }

    public static Point3D getNearestBlock(Entity entity, int horizontalRange, int verticalRange, Block blockType) {
        return RadixLogic.getNearestBlock(Point3D.fromEntityPosition(entity), entity.field_70170_p, horizontalRange, verticalRange, blockType);
    }

    public static Point3D getNearestBlock(Entity entity, int horizontalRange, Block blockType) {
        return RadixLogic.getNearestBlock(Point3D.fromEntityPosition(entity), entity.field_70170_p, horizontalRange, 3, blockType);
    }

    public static Point3D getFarthestBlock(Point3D origin, World world, int horizontalRange, int verticalRange, Block blockType) {
        Point3D returnPoint = Point3D.NONE;
        double farthest = 0.0;
        for (Point3D point : RadixLogic.getNearbyBlocks(origin, world, blockType, horizontalRange, verticalRange)) {
            double distance = RadixMath.getDistanceToXYZ(origin.dX(), origin.dY(), origin.dZ(), point.dX(), point.dY(), point.dZ());
            if (!(distance > farthest)) continue;
            farthest = distance;
            returnPoint = point;
        }
        return returnPoint;
    }

    public static Point3D getFarthestBlock(Entity entity, int horizontalRange, int verticalRange, Block blockType) {
        return RadixLogic.getFarthestBlock(Point3D.fromEntityPosition(entity), entity.field_70170_p, horizontalRange, verticalRange, blockType);
    }

    public static Point3D getFarthestBlock(Entity entity, int horizontalRange, Block blockType) {
        return RadixLogic.getFarthestBlock(Point3D.fromEntityPosition(entity), entity.field_70170_p, horizontalRange, 3, blockType);
    }

    public static List<Point3D> getNearbyBlocks(Point3D origin, World world, @Nullable Block filter, int horizontalRange, int verticalRange) {
        int x = origin.iX();
        int y = origin.iY();
        int z = origin.iZ();
        int xMov = 0 - horizontalRange;
        int yMov = verticalRange;
        int zMov = 0 - horizontalRange;
        ArrayList<Point3D> pointsList = new ArrayList<Point3D>();
        while (true) {
            Block currentBlock = RadixBlocks.getBlock(world, x + xMov, y + yMov, z + zMov);
            if (filter == null || filter != null && currentBlock == filter) {
                pointsList.add(new Point3D(x + xMov, y + yMov, z + zMov));
            }
            if (zMov == horizontalRange && xMov == horizontalRange && yMov == verticalRange * -1) break;
            if (zMov == horizontalRange && xMov == horizontalRange) {
                --yMov;
                xMov = 0 - horizontalRange;
                zMov = 0 - horizontalRange;
                continue;
            }
            if (xMov == horizontalRange) {
                ++zMov;
                xMov = 0 - horizontalRange;
                continue;
            }
            ++xMov;
        }
        return pointsList;
    }

    public static List<Point3D> getNearbyBlocks(Entity entity, @Nullable Block filter, int verticalRange) {
        return RadixLogic.getNearbyBlocks(Point3D.fromEntityPosition(entity), entity.field_70170_p, filter, verticalRange, 3);
    }

    public static List<Point3D> getNearbyBlocks(Entity entity, @Nullable Block filter, int horizontalRange, int verticalRange) {
        return RadixLogic.getNearbyBlocks(Point3D.fromEntityPosition(entity), entity.field_70170_p, filter, horizontalRange, verticalRange);
    }

    public static List<Point3D> getNearbyBlocks(Point3D origin, World world, @Nullable Block filter, int horizontalRange) {
        return RadixLogic.getNearbyBlocks(origin, world, filter, horizontalRange, 3);
    }

    public static List<Point3D> getNearbyBlocks(Point3D origin, World world, Class filter, int horizontalRange) {
        List<Point3D> allNearbyBlocks = RadixLogic.getNearbyBlocks(origin, world, null, horizontalRange, 3);
        ArrayList<Point3D> returnList = new ArrayList<Point3D>();
        for (Point3D point : allNearbyBlocks) {
            if (world.func_180495_p(point.toBlockPos()).func_177230_c().getClass() != filter) continue;
            returnList.add(point);
        }
        return returnList;
    }

    public static List<Point3D> getNearbyBlocks(Entity origin, Class filter, int horizontalRange) {
        return RadixLogic.getNearbyBlocks(Point3D.fromEntityPosition(origin), origin.field_70170_p, filter, horizontalRange);
    }

    public static <T extends Entity> List<T> getEntitiesWithinDistance(Class<T> filter, World world, double posX, double posY, double posZ, int maxDistanceAway) {
        return world.func_72872_a(filter, new AxisAlignedBB(posX - (double)maxDistanceAway, posY - (double)maxDistanceAway, posZ - (double)maxDistanceAway, posX + (double)maxDistanceAway, posY + (double)maxDistanceAway, posZ + (double)maxDistanceAway));
    }

    public static <T extends Entity> List<T> getEntitiesWithinDistance(Class<T> filter, Entity origin, int maxDistanceAway) {
        return RadixLogic.getEntitiesWithinDistance(filter, origin.field_70170_p, Point3D.fromEntityPosition(origin), maxDistanceAway);
    }

    public static <T extends Entity> List<T> getEntitiesWithinDistance(Class<T> filter, World world, Point3D origin, int maxDistanceAway) {
        return RadixLogic.getEntitiesWithinDistance(filter, world, origin.dX(), origin.dY(), origin.dZ(), maxDistanceAway);
    }

    public static int getSpawnSafeTopLevel(World world, int x, int y, int z) {
        Block block = Blocks.field_150350_a;
        while (block == Blocks.field_150350_a && y > 0) {
            block = RadixBlocks.getBlock(world, x, --y, z);
        }
        return y + 1;
    }

    public static int getSpawnSafeTopLevel(World world, int x, int z) {
        return RadixLogic.getSpawnSafeTopLevel(world, x, 256, z);
    }

    public static boolean getBooleanWithProbability(int probabilityOfTrue) {
        if ((probabilityOfTrue = MathHelper.func_76125_a((int)probabilityOfTrue, (int)0, (int)100)) <= 0) {
            return false;
        }
        return new Random().nextInt(100) + 1 <= probabilityOfTrue;
    }

    @Deprecated
    public static Point3D getFirstNearestBlockWithMeta(Entity entity, Block block, int meta, int maxDistanceAway) {
        int x = (int)entity.field_70165_t;
        int y = (int)entity.field_70163_u;
        int z = (int)entity.field_70161_v;
        int xMov = 0 - maxDistanceAway;
        int yMov = 3;
        int zMov = 0 - maxDistanceAway;
        while (true) {
            IBlockState state = entity.field_70170_p.func_180495_p(new BlockPos(x + xMov, y + yMov, z + zMov));
            Block currentBlock = state.func_177230_c();
            int currentMeta = currentBlock.func_176201_c(state);
            if (currentBlock == block && currentMeta == meta) {
                return new Point3D(x + xMov, y + yMov, z + zMov);
            }
            if (zMov == maxDistanceAway && xMov == maxDistanceAway && yMov == -3) break;
            if (zMov == maxDistanceAway && xMov == maxDistanceAway) {
                --yMov;
                xMov = 0 - maxDistanceAway;
                zMov = 0 - maxDistanceAway;
                continue;
            }
            if (xMov == maxDistanceAway) {
                ++zMov;
                xMov = 0 - maxDistanceAway;
                continue;
            }
            ++xMov;
        }
        return null;
    }
}

