/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules;

import java.util.Random;
import net.minecraft.entity.Entity;
import radixcore.math.Point3D;

public final class RadixMath {
    private static final Random rand = new Random();

    public static boolean isWithinRange(int input, int minimum, int maximum) {
        return input >= minimum && input <= maximum;
    }

    public static boolean isWithinRange(float input, float minimum, float maximum) {
        return input >= minimum && input <= maximum;
    }

    public static int getNumberInRange(int minimum, int maximum) {
        return rand.nextInt(maximum - minimum + 1) + minimum;
    }

    public static float getNumberInRange(float minimum, float maximum) {
        return rand.nextFloat() * (maximum - minimum) + minimum;
    }

    public static double getNumberInRangeWithDeviation(float standardDeviation, float mean) {
        return rand.nextGaussian() * (double)standardDeviation + (double)mean;
    }

    public static double getDistanceToEntity(Entity entity1, Entity entity2) {
        return RadixMath.getDistanceToXYZ(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, entity2.field_70165_t, entity2.field_70163_u, entity2.field_70161_v);
    }

    public static double getDistanceToXYZ(double x1, double y1, double z1, double x2, double y2, double z2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        double deltaZ = z2 - z1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistanceToXYZ(Entity entity, Point3D point) {
        return RadixMath.getDistanceToXYZ(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, point.dX(), point.dY(), point.dZ());
    }

    public static double getDistanceToXYZ(Point3D point1, Point3D point2) {
        return RadixMath.getDistanceToXYZ(point1.dX(), point1.dY(), point1.dZ(), point2.dX(), point2.dY(), point2.dZ());
    }

    public static float getHighestNumber(float ... numbers) {
        float highestNumber = 0.0f;
        for (float i : numbers) {
            if (!(i > highestNumber)) continue;
            highestNumber = i;
        }
        return highestNumber;
    }

    public static int getHighestNumber(int ... numbers) {
        int highestNumber = 0;
        for (int i : numbers) {
            if (i <= highestNumber) continue;
            highestNumber = i;
        }
        return highestNumber;
    }

    public static float getLowestNumber(float ... numbers) {
        float lowestNumber = 999.9f;
        for (float i : numbers) {
            if (!(i < lowestNumber)) continue;
            lowestNumber = i;
        }
        return lowestNumber;
    }

    public static int getLowestNumber(int ... numbers) {
        int lowestNumber = 999;
        for (int i : numbers) {
            if (i >= lowestNumber) continue;
            lowestNumber = i;
        }
        return lowestNumber;
    }

    public static int clamp(int input, int min, int max) {
        return input < min ? min : (input > max ? max : input);
    }

    public static float clamp(float input, float min, float max) {
        return input < min ? min : (input > max ? max : input);
    }

    private RadixMath() {
    }
}

