/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules.schematics;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import radixcore.core.RadixCore;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.schematics.BlockObj;

public final class RadixSchematics {
    public static Point3D getPoint3DWithValue(Map<Point3D, BlockObj> schematicData, Point3D point) {
        for (Map.Entry<Point3D, BlockObj> entry : schematicData.entrySet()) {
            if (!entry.getKey().equals(point)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static int countOccurencesOfBlockObj(Map<Point3D, BlockObj> schematicData, BlockObj searchBlock) {
        int count = 0;
        for (BlockObj block : schematicData.values()) {
            if (!block.equals(searchBlock)) continue;
            ++count;
        }
        return count;
    }

    public static SortedMap<Point3D, BlockObj> readSchematic(String location) {
        Point3D origin = null;
        Point3D offset = null;
        TreeMap<Point3D, BlockObj> map = new TreeMap<Point3D, BlockObj>();
        NBTTagCompound nbtdata = null;
        try {
            nbtdata = CompressedStreamTools.func_74796_a((InputStream)RadixSchematics.class.getResourceAsStream(location));
        }
        catch (IOException e) {
            RadixCore.getLogger().error("Failed to load schematic: " + location);
            return map;
        }
        int width = nbtdata.func_74765_d("Width");
        int height = nbtdata.func_74765_d("Height");
        int length = nbtdata.func_74765_d("Length");
        byte[] blockIds = nbtdata.func_74770_j("Blocks");
        byte[] data = nbtdata.func_74770_j("Data");
        byte[] addIds = new byte[]{};
        short[] blocks = new short[blockIds.length];
        if (nbtdata.func_74764_b("AddBlocks")) {
            addIds = nbtdata.func_74770_j("AddBlocks");
        }
        try {
            int originX = nbtdata.func_74762_e("WEOriginX");
            int originY = nbtdata.func_74762_e("WEOriginY");
            int originZ = nbtdata.func_74762_e("WEOriginZ");
            Point3D min = new Point3D(originX, originY, originZ);
            int offsetX = nbtdata.func_74762_e("WEOffsetX");
            int offsetY = nbtdata.func_74762_e("WEOffsetY");
            int offsetZ = nbtdata.func_74762_e("WEOffsetZ");
            offset = new Point3D(offsetX, offsetY, offsetZ);
            origin = new Point3D(min.iX() - offset.iX(), min.iY() - offset.iY(), min.iZ() - offset.iZ());
        }
        catch (Exception ignore) {
            origin = Point3D.ZERO;
        }
        for (int index = 0; index < blockIds.length; ++index) {
            blocks[index] = index >> 1 >= addIds.length ? (short)(blockIds[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addIds[index >> 1] & 0xF) << 8) + (blockIds[index] & 0xFF)) : (short)(((addIds[index >> 1] & 0xF0) << 4) + (blockIds[index] & 0xFF)));
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = y * width * length + z * width + x;
                    Point3D point = new Point3D(x + offset.iX(), y + offset.iY() - 1, z + offset.iZ());
                    BlockObj block = new BlockObj(Block.func_149729_e((int)blocks[index]), data[index]);
                    map.put(point, block);
                }
            }
        }
        return map;
    }

    public static void spawnStructureRelativeToPlayer(String location, EntityPlayer player) {
        RadixSchematics.spawnStructureRelativeToPoint(location, new Point3D(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), player.field_70170_p);
    }

    public static void spawnStructureRelativeToPoint(String location, Point3D point, World world) {
        IBlockState state;
        BlockObj blockObj;
        int z;
        int y;
        int x;
        Point3D blockPoint;
        SortedMap<Point3D, BlockObj> schemBlocks = RadixSchematics.readSchematic(location);
        HashMap torchMap = new HashMap();
        HashMap doorMap = new HashMap();
        for (Map.Entry entry : schemBlocks.entrySet()) {
            if (((BlockObj)entry.getValue()).getBlock() == Blocks.field_150478_aa) {
                torchMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (((BlockObj)entry.getValue()).getBlock() == Blocks.field_180413_ao) {
                doorMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            blockPoint = (Point3D)entry.getKey();
            x = blockPoint.iX() + point.iX();
            y = blockPoint.iY() + point.iY();
            z = blockPoint.iZ() + point.iZ();
            Block currentBlockAtPoint = RadixBlocks.getBlock(world, x, y, z);
            BlockObj blockObj2 = (BlockObj)entry.getValue();
            IBlockState state2 = blockObj2.getBlock().func_176203_a(blockObj2.getMeta());
            if (currentBlockAtPoint == Blocks.field_150329_H) {
                RadixBlocks.setBlock(world, x, y + 1, z, Blocks.field_150350_a);
                RadixBlocks.setBlock(world, x, y, z, Blocks.field_150350_a);
            }
            if (blockObj2.getBlock() == Blocks.field_150398_cm) continue;
            world.func_175656_a(new BlockPos(x, y, z), state2);
        }
        for (Map.Entry entry : torchMap.entrySet()) {
            blockPoint = (Point3D)entry.getKey();
            x = blockPoint.iX() + point.iX();
            y = blockPoint.iY() + point.iY();
            z = blockPoint.iZ() + point.iZ();
            blockObj = (BlockObj)entry.getValue();
            state = blockObj.getBlock().func_176203_a(blockObj.getMeta());
            world.func_175656_a(new BlockPos(x, y, z), state);
        }
        for (Map.Entry entry : doorMap.entrySet()) {
            blockPoint = (Point3D)entry.getKey();
            x = blockPoint.iX() + point.iX();
            y = blockPoint.iY() + point.iY();
            z = blockPoint.iZ() + point.iZ();
            blockObj = (BlockObj)entry.getValue();
            state = blockObj.getBlock().func_176203_a(blockObj.getMeta());
            world.func_175656_a(new BlockPos(x, y, z), state);
        }
    }
}

